/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.resource.spi.work.Work;
import org.mule.DefaultMuleMessage;
import org.mule.MuleServer;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.MessageAdapter;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.transport.AbstractMessageReceiver;

public abstract class AbstractReceiverWorker
implements Work {
    protected List messages;
    protected ImmutableEndpoint endpoint;
    protected AbstractMessageReceiver receiver;
    protected OutputStream out;

    public AbstractReceiverWorker(List messages, AbstractMessageReceiver receiver) {
        this(messages, receiver, null);
    }

    public AbstractReceiverWorker(List messages, AbstractMessageReceiver receiver, OutputStream out) {
        this.messages = messages;
        this.receiver = receiver;
        this.endpoint = receiver.getEndpoint();
        this.out = out;
    }

    public final void run() {
        this.doRun();
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() {
        MuleContext muleContext = MuleServer.getMuleContext();
        TransactionTemplate tt = new TransactionTemplate(this.endpoint.getTransactionConfig(), this.endpoint.getConnector().getExceptionListener(), muleContext);
        TransactionCallback cb = new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                Transaction tx = TransactionCoordination.getInstance().getTransaction();
                if (tx != null) {
                    AbstractReceiverWorker.this.bindTransaction(tx);
                }
                ArrayList results = new ArrayList(AbstractReceiverWorker.this.messages.size());
                for (Object o : AbstractReceiverWorker.this.messages) {
                    if ((o = AbstractReceiverWorker.this.preProcessMessage(o)) == null) continue;
                    MessageAdapter adapter = o instanceof MessageAdapter ? (MessageAdapter)o : AbstractReceiverWorker.this.endpoint.getConnector().getMessageAdapter(o);
                    DefaultMuleMessage muleMessage = new DefaultMuleMessage(adapter);
                    AbstractReceiverWorker.this.preRouteMuleMessage(muleMessage);
                    MuleMessage result = AbstractReceiverWorker.this.receiver.routeMessage(muleMessage, tx, tx != null || AbstractReceiverWorker.this.endpoint.isSynchronous(), AbstractReceiverWorker.this.out);
                    if (result == null || (o = AbstractReceiverWorker.this.postProcessMessage(result)) == null) continue;
                    results.add(o);
                }
                return results;
            }
        };
        try {
            List results = (List)tt.execute(cb);
            this.handleResults(results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.messages.clear();
        }
    }

    protected void preRouteMuleMessage(DefaultMuleMessage message) throws Exception {
    }

    protected abstract void bindTransaction(Transaction var1) throws TransactionException;

    protected void handleException(Exception e) {
        this.endpoint.getConnector().handleException(e);
    }

    protected void handleResults(List messages) throws Exception {
    }

    protected Object preProcessMessage(Object message) throws Exception {
        return message;
    }

    protected MuleMessage postProcessMessage(MuleMessage message) throws Exception {
        return message;
    }

    public void release() {
    }
}

