/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.codec;

import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.Base64;

public class Base64Encoder
extends AbstractTransformer {
    public Base64Encoder() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.setReturnClass(String.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            byte[] buf = src instanceof String ? ((String)src).getBytes(encoding) : (byte[])src;
            String result = Base64.encodeBytes(buf, 8);
            if (this.getReturnClass().equals(byte[].class)) {
                return result.getBytes(encoding);
            }
            return result;
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed(src.getClass().getName(), "base64"), this, (Throwable)ex);
        }
    }
}

