/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction.lookup;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.TransactionManagerFactory;
import org.mule.util.ClassUtils;

public class WebsphereTransactionManagerLookupFactory
implements TransactionManagerFactory {
    private static final String FACTORY_CLASS_5_1_AND_ABOVE = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String FACTORY_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
    private static final String FACTORY_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
    private final Log logger = LogFactory.getLog(this.getClass());

    public TransactionManager create() {
        TransactionManager transactionManager;
        Class clazz;
        try {
            this.logger.debug((Object)"Trying WebSphere 5.1+: com.ibm.ws.Transaction.TransactionManagerFactory");
            clazz = ClassUtils.loadClass(FACTORY_CLASS_5_1_AND_ABOVE, this.getClass());
            this.logger.info((Object)"Found WebSphere 5.1+: com.ibm.ws.Transaction.TransactionManagerFactory");
        }
        catch (ClassNotFoundException ex) {
            this.logger.debug((Object)"Could not find WebSphere 5.1+ TransactionManager factory class", (Throwable)ex);
            try {
                this.logger.debug((Object)"Trying WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
                clazz = ClassUtils.loadClass(FACTORY_CLASS_5_0, this.getClass());
                this.logger.info((Object)"Found WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
            }
            catch (ClassNotFoundException ex2) {
                this.logger.debug((Object)"Could not find WebSphere 5.0 TransactionManager factory class", (Throwable)ex2);
                try {
                    this.logger.debug((Object)"Trying WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                    clazz = ClassUtils.loadClass(FACTORY_CLASS_4, this.getClass());
                    this.logger.info((Object)"Found WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                }
                catch (ClassNotFoundException ex3) {
                    this.logger.debug((Object)"Could not find WebSphere 4 TransactionManager factory class", (Throwable)ex3);
                    throw new RuntimeException("Couldn't find any WebSphere TransactionManager factory class, neither for WebSphere version 5.1 nor 5.0 nor 4", ex);
                }
            }
        }
        try {
            Method method = clazz.getMethod("getTransactionManager", null);
            transactionManager = (TransactionManager)method.invoke(null, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Found WebSphere TransactionManager factory class [" + clazz.getName() + "], but couldn't invoke its static 'getTransactionManager' method", ex);
        }
        return transactionManager;
    }
}

