/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.providers;

import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.transport.MessageAdapter;
import org.mule.tck.AbstractMuleTestCase;

public abstract class AbstractMessageAdapterTestCase
extends AbstractMuleTestCase {
    protected void doSetUp() throws Exception {
        RequestContext.setEvent(AbstractMessageAdapterTestCase.getTestEvent("hello"));
    }

    protected void doTearDown() throws Exception {
        RequestContext.clear();
    }

    protected void doTestMessageEqualsPayload(Object message, Object payload) throws Exception {
        AbstractMessageAdapterTestCase.assertEquals((Object)message, (Object)payload);
    }

    public void testMessageRetrieval() throws Exception {
        Object message = this.getValidMessage();
        MessageAdapter adapter = this.createAdapter(message);
        DefaultMuleMessage muleMessage = new DefaultMuleMessage(adapter);
        this.doTestMessageEqualsPayload(message, adapter.getPayload());
        byte[] bytes = muleMessage.getPayloadAsBytes();
        AbstractMessageAdapterTestCase.assertNotNull((Object)bytes);
        String stringMessage = muleMessage.getPayloadAsString();
        AbstractMessageAdapterTestCase.assertNotNull((Object)stringMessage);
        AbstractMessageAdapterTestCase.assertNotNull((Object)adapter.getPayload());
    }

    public void testMessageProps() throws Exception {
        MessageAdapter adapter = this.createAdapter(this.getValidMessage());
        adapter.setProperty("TestString", "Test1");
        adapter.setProperty("TestLong", new Long(20000000L));
        adapter.setProperty("TestInt", new Integer(200000));
        AbstractMessageAdapterTestCase.assertNotNull((Object)adapter.getPropertyNames());
        Object prop = adapter.getProperty("TestString");
        AbstractMessageAdapterTestCase.assertNotNull((Object)prop);
        AbstractMessageAdapterTestCase.assertEquals((Object)"Test1", (Object)prop);
        prop = adapter.getProperty("TestLong");
        AbstractMessageAdapterTestCase.assertNotNull((Object)prop);
        AbstractMessageAdapterTestCase.assertEquals((Object)new Long(20000000L), (Object)prop);
        prop = adapter.getProperty("TestInt");
        AbstractMessageAdapterTestCase.assertNotNull((Object)prop);
        AbstractMessageAdapterTestCase.assertEquals((Object)new Integer(200000), (Object)prop);
    }

    public Object getInvalidMessage() {
        return new InvalidMessage();
    }

    public abstract Object getValidMessage() throws Exception;

    public abstract MessageAdapter createAdapter(Object var1) throws MessagingException;

    final class InvalidMessage {
        InvalidMessage() {
        }

        public String toString() {
            return "invalid message";
        }
    }
}

