/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.mule.DefaultExceptionStrategy;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionManagerFactory;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transaction.TransactionTemplate;
import org.mule.transaction.XaTransaction;
import org.mule.transaction.XaTransactionFactory;

public abstract class AbstractTxThreadAssociationTestCase
extends AbstractMuleTestCase {
    private TransactionManager tm;
    protected static final int TRANSACTION_TIMEOUT_SECONDS = 3;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        TransactionManagerFactory factory = this.getTransactionManagerFactory();
        this.tm = factory.create();
        AbstractTxThreadAssociationTestCase.assertNotNull((String)"Transaction Manager should be available.", (Object)this.tm);
        AbstractTxThreadAssociationTestCase.assertNull((String)"There sould be no current transaction associated.", (Object)this.tm.getTransaction());
    }

    public void testTxHandleCommitKeepsThreadAssociation() throws Exception {
        this.tm.setTransactionTimeout(3);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        AbstractTxThreadAssociationTestCase.assertNotNull((String)"Transaction should have started.", (Object)tx);
        AbstractTxThreadAssociationTestCase.assertEquals((String)"TX should have been active", (int)0, (int)tx.getStatus());
        tx.commit();
        tx = this.tm.getTransaction();
        AbstractTxThreadAssociationTestCase.assertNotNull((String)"Committing via TX handle should NOT disassociated TX from the current thread.", (Object)tx);
        AbstractTxThreadAssociationTestCase.assertEquals((String)"TX status should have been COMMITTED.", (int)3, (int)tx.getStatus());
        Transaction suspended = this.tm.suspend();
        AbstractTxThreadAssociationTestCase.assertTrue((String)"Wrong TX suspended?.", (boolean)suspended.equals(tx));
        AbstractTxThreadAssociationTestCase.assertNull((String)"TX should've been disassociated from the thread.", (Object)this.tm.getTransaction());
        this.tm.resume(null);
        AbstractTxThreadAssociationTestCase.assertNull((Object)this.tm.getTransaction());
    }

    public void testTxManagerCommitDissassociatesThread() throws Exception {
        this.tm.setTransactionTimeout(3);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        AbstractTxThreadAssociationTestCase.assertNotNull((String)"Transaction should have started.", (Object)tx);
        AbstractTxThreadAssociationTestCase.assertEquals((String)"TX should have been active", (int)0, (int)tx.getStatus());
        this.tm.commit();
        AbstractTxThreadAssociationTestCase.assertNull((String)"Committing via TX Manager should have disassociated TX from the current thread.", (Object)this.tm.getTransaction());
    }

    public void testTxManagerRollbackDissassociatesThread() throws Exception {
        this.tm.setTransactionTimeout(3);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        AbstractTxThreadAssociationTestCase.assertNotNull((String)"Transaction should have started.", (Object)tx);
        AbstractTxThreadAssociationTestCase.assertEquals((String)"TX should have been active", (int)0, (int)tx.getStatus());
        this.tm.rollback();
        AbstractTxThreadAssociationTestCase.assertNull((String)"Committing via TX Manager should have disassociated TX from the current thread.", (Object)this.tm.getTransaction());
    }

    public void testAlwaysBeginXaTransactionSuspendResume() throws Exception {
        muleContext.setTransactionManager(this.tm);
        AbstractTxThreadAssociationTestCase.assertNull((String)"There sould be no current transaction associated.", (Object)this.tm.getTransaction());
        this.tm.setTransactionTimeout(3);
        MuleTransactionConfig config = new MuleTransactionConfig();
        config.setFactory(new XaTransactionFactory());
        config.setAction((byte)1);
        TransactionTemplate template = new TransactionTemplate(config, new DefaultExceptionStrategy(), muleContext);
        final MuleTransactionConfig nestedConfig = new MuleTransactionConfig();
        nestedConfig.setFactory(new XaTransactionFactory());
        nestedConfig.setAction((byte)1);
        template.execute(new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                TransactionTemplate nestedTemplate = new TransactionTemplate(nestedConfig, new DefaultExceptionStrategy(), AbstractMuleTestCase.muleContext);
                final Transaction firstTx = AbstractTxThreadAssociationTestCase.this.tm.getTransaction();
                Assert.assertNotNull((Object)firstTx);
                Assert.assertEquals((int)firstTx.getStatus(), (int)0);
                return nestedTemplate.execute(new TransactionCallback(){

                    public Object doInTransaction() throws Exception {
                        Transaction secondTx = AbstractTxThreadAssociationTestCase.this.tm.getTransaction();
                        Assert.assertNotNull((Object)secondTx);
                        Assert.assertEquals((int)firstTx.getStatus(), (int)0);
                        Assert.assertEquals((int)secondTx.getStatus(), (int)0);
                        try {
                            AbstractTxThreadAssociationTestCase.this.tm.resume(firstTx);
                            Assert.fail((String)"Second transaction must be active");
                        }
                        catch (IllegalStateException e) {
                            // empty catch block
                        }
                        try {
                            Transaction currentTx = AbstractTxThreadAssociationTestCase.this.tm.suspend();
                            Assert.assertTrue((boolean)currentTx.equals(secondTx));
                            AbstractTxThreadAssociationTestCase.this.tm.resume(firstTx);
                            Assert.assertEquals((Object)firstTx, (Object)AbstractTxThreadAssociationTestCase.this.tm.getTransaction());
                            Assert.assertEquals((int)firstTx.getStatus(), (int)0);
                            Assert.assertEquals((int)secondTx.getStatus(), (int)0);
                            Transaction a = AbstractTxThreadAssociationTestCase.this.tm.suspend();
                            Assert.assertTrue((boolean)a.equals(firstTx));
                            AbstractTxThreadAssociationTestCase.this.tm.resume(secondTx);
                        }
                        catch (Exception e) {
                            Assert.fail((String)("Error: " + e));
                        }
                        return null;
                    }
                });
            }
        });
        AbstractTxThreadAssociationTestCase.assertNull((String)"Committing via TX Manager should have disassociated TX from the current thread.", (Object)this.tm.getTransaction());
    }

    public void testXaTransactionTermination() throws Exception {
        muleContext.setTransactionManager(this.tm);
        AbstractTxThreadAssociationTestCase.assertNull((String)"There sould be no current transaction associated.", (Object)this.tm.getTransaction());
        this.tm.setTransactionTimeout(3);
        XaTransaction muleTx = new XaTransaction(this.tm);
        AbstractTxThreadAssociationTestCase.assertFalse((boolean)muleTx.isBegun());
        AbstractTxThreadAssociationTestCase.assertEquals((int)6, (int)muleTx.getStatus());
        muleTx.begin();
        AbstractTxThreadAssociationTestCase.assertTrue((boolean)muleTx.isBegun());
        muleTx.commit();
        Transaction jtaTx = this.tm.getTransaction();
        AbstractTxThreadAssociationTestCase.assertNull((String)"Committing via TX Manager should have disassociated TX from the current thread.", (Object)jtaTx);
        AbstractTxThreadAssociationTestCase.assertEquals((int)6, (int)muleTx.getStatus());
    }

    public void testNoNestedTxStarted() throws Exception {
        muleContext.setTransactionManager(this.tm);
        AbstractTxThreadAssociationTestCase.assertNull((String)"There sould be no current transaction associated.", (Object)this.tm.getTransaction());
        this.tm.setTransactionTimeout(3);
        MuleTransactionConfig config = new MuleTransactionConfig();
        config.setFactory(new XaTransactionFactory());
        config.setAction((byte)1);
        TransactionTemplate template = new TransactionTemplate(config, new DefaultExceptionStrategy(), muleContext);
        final MuleTransactionConfig nestedConfig = new MuleTransactionConfig();
        nestedConfig.setFactory(new XaTransactionFactory());
        nestedConfig.setAction((byte)2);
        template.execute(new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                TransactionTemplate nestedTemplate = new TransactionTemplate(nestedConfig, new DefaultExceptionStrategy(), AbstractMuleTestCase.muleContext);
                return nestedTemplate.execute(new TransactionCallback(){

                    public Object doInTransaction() throws Exception {
                        return null;
                    }
                });
            }
        });
    }

    protected TransactionManager getTransactionManager() {
        return this.tm;
    }

    protected abstract TransactionManagerFactory getTransactionManagerFactory();
}

