/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import org.mule.DefaultExceptionStrategy;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.service.Service;
import org.mule.management.stats.ServiceStatistics;
import org.mule.service.AbstractService;

public class DefaultServiceExceptionStrategy
extends DefaultExceptionStrategy {
    protected Service service;
    protected ServiceStatistics statistics;

    public DefaultServiceExceptionStrategy() {
    }

    public DefaultServiceExceptionStrategy(Service service) {
        this.setService(service);
    }

    public Service getService() {
        return this.service;
    }

    protected void defaultHandler(Throwable t) {
        if (this.service == null) {
            MuleEvent event = RequestContext.getEvent();
            if (event == null) {
                this.logger.fatal((Object)"The Default Service Exception Strategy has been invoked but there is no current event on the context");
                this.logger.fatal((Object)("The error is: " + t.getMessage()), t);
            } else {
                this.setService(event.getService());
            }
        }
        if (this.statistics != null) {
            this.statistics.incExecutionError();
        }
        super.defaultHandler(t);
    }

    protected void logFatal(MuleMessage message, Throwable t) {
        super.logFatal(message, t);
        if (this.statistics != null) {
            this.statistics.incFatalError();
        }
    }

    protected void routeException(MuleMessage message, ImmutableEndpoint failedEndpoint, Throwable t) {
        ImmutableEndpoint ep = this.getEndpoint(t);
        if (ep != null) {
            super.routeException(message, failedEndpoint, t);
            if (this.statistics != null) {
                this.statistics.getOutboundRouterStat().incrementRoutedMessage(ep);
            }
        }
    }

    public void setService(Service service) {
        this.service = service;
        if (service instanceof AbstractService && this.statistics != null) {
            this.statistics = ((AbstractService)service).getStatistics();
        }
    }
}

