/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.EncryptionStrategy;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityManager;
import org.mule.api.security.SecurityProvider;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnknownAuthenticationTypeException;

public class MuleSecurityManager
implements SecurityManager {
    protected static final Log logger = LogFactory.getLog(MuleSecurityManager.class);
    private Map providers = new ConcurrentHashMap();
    private Map cryptoStrategies = new ConcurrentHashMap();

    public void initialise() throws InitialisationException {
        for (SecurityProvider provider : this.providers.values()) {
            provider.initialise();
        }
        for (EncryptionStrategy strategy : this.cryptoStrategies.values()) {
            strategy.initialise();
        }
    }

    public Authentication authenticate(Authentication authentication) throws SecurityException, SecurityProviderNotFoundException {
        Iterator iter = this.providers.values().iterator();
        Class<?> toTest = authentication.getClass();
        while (iter.hasNext()) {
            Authentication result;
            SecurityProvider provider = (SecurityProvider)iter.next();
            if (!provider.supports(toTest)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication attempt using " + provider.getClass().getName()));
            }
            if ((result = provider.authenticate(authentication)) == null) continue;
            return result;
        }
        throw new SecurityProviderNotFoundException(toTest.getName());
    }

    public void addProvider(SecurityProvider provider) {
        if (this.getProvider(provider.getName()) != null) {
            throw new IllegalArgumentException("Provider already registered: " + provider.getName());
        }
        this.providers.put(provider.getName(), provider);
    }

    public SecurityProvider getProvider(String name) {
        if (name == null) {
            throw new IllegalArgumentException("provider Name cannot be null");
        }
        return (SecurityProvider)this.providers.get(name);
    }

    public SecurityProvider removeProvider(String name) {
        return (SecurityProvider)this.providers.remove(name);
    }

    public Collection getProviders() {
        return Collections.unmodifiableCollection(new ArrayList(this.providers.values()));
    }

    public void setProviders(Collection providers) {
        for (SecurityProvider provider : providers) {
            this.addProvider(provider);
        }
    }

    public SecurityContext createSecurityContext(Authentication authentication) throws UnknownAuthenticationTypeException {
        Iterator iter = this.providers.values().iterator();
        Class<?> toTest = authentication.getClass();
        while (iter.hasNext()) {
            SecurityProvider provider = (SecurityProvider)iter.next();
            if (!provider.supports(toTest)) continue;
            return provider.createSecurityContext(authentication);
        }
        throw new UnknownAuthenticationTypeException(authentication);
    }

    public EncryptionStrategy getEncryptionStrategy(String name) {
        return (EncryptionStrategy)this.cryptoStrategies.get(name);
    }

    public void addEncryptionStrategy(EncryptionStrategy strategy) {
        this.cryptoStrategies.put(strategy.getName(), strategy);
    }

    public EncryptionStrategy removeEncryptionStrategy(String name) {
        return (EncryptionStrategy)this.cryptoStrategies.remove(name);
    }

    public Collection getEncryptionStrategies() {
        return Collections.unmodifiableCollection(new ArrayList(this.cryptoStrategies.values()));
    }

    public void setEncryptionStrategies(Collection strategies) {
        for (EncryptionStrategy strategy : strategies) {
            this.addEncryptionStrategy(strategy);
        }
    }
}

