/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InvalidEndpointTypeException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.ResponseRouter;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.routing.Router;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRouterCollection;

public class DefaultResponseRouterCollection
extends AbstractRouterCollection
implements ResponseRouterCollection {
    private volatile List endpoints = new CopyOnWriteArrayList();
    private volatile int timeout = 10000;
    private volatile boolean failOnTimeout = true;

    public DefaultResponseRouterCollection() {
        super(3);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        for (ImmutableEndpoint endpoint : this.endpoints) {
            endpoint.initialise();
        }
    }

    public void route(MuleEvent event) throws RoutingException {
        for (ResponseRouter router : this.getRouters()) {
            router.process(event);
            if (!this.getStatistics().isEnabled()) continue;
            this.getStatistics().incrementRoutedMessage(event.getEndpoint());
        }
    }

    public MuleMessage getResponse(MuleMessage message) throws RoutingException {
        MuleMessage result = null;
        if (this.routers.size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"There are no routers configured on the response router. Returning the current message");
            }
            result = message;
        } else {
            for (ResponseRouter router : this.getRouters()) {
                result = router.getResponse(message);
            }
            if (result == null && this.getStatistics().isEnabled()) {
                this.getStatistics().incrementNoRoutedMessage();
            }
        }
        return result;
    }

    public void addRouter(Router router) {
        ((ResponseRouter)router).setTimeout(this.getTimeout());
        ((ResponseRouter)router).setFailOnTimeout(this.isFailOnTimeout());
        this.routers.add(router);
    }

    public ResponseRouter removeRouter(ResponseRouter router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    public void addEndpoint(ImmutableEndpoint endpoint) {
        if (endpoint != null) {
            if (!endpoint.isInbound()) {
                throw new InvalidEndpointTypeException(CoreMessages.responseRouterMustUseInboundEndpoints(this, endpoint));
            }
        } else {
            throw new IllegalArgumentException("endpoint = null");
        }
        this.endpoints.add(endpoint);
    }

    public boolean removeEndpoint(ImmutableEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        if (endpoints != null) {
            this.endpoints.clear();
            this.endpoints.addAll(endpoints);
            for (ImmutableEndpoint endpoint : this.endpoints) {
                if (endpoint.isInbound()) continue;
                throw new InvalidEndpointTypeException(CoreMessages.responseRouterMustUseInboundEndpoints(this, endpoint));
            }
        } else {
            throw new IllegalArgumentException("List of endpoints = null");
        }
    }

    public ImmutableEndpoint getEndpoint(String name) {
        for (ImmutableEndpoint endpointDescriptor : this.endpoints) {
            if (!endpointDescriptor.getName().equals(name)) continue;
            return endpointDescriptor;
        }
        return null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    public boolean hasEndpoints() {
        return !this.getEndpoints().isEmpty();
    }
}

