/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.DefaultMuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.ServiceRoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractCatchAllStrategy;

public class ForwardingCatchAllStrategy
extends AbstractCatchAllStrategy {
    private boolean sendTransformed = false;

    public MuleMessage catchMessage(MuleMessage message, MuleSession session, boolean synchronous) throws RoutingException {
        if (this.getEndpoint() == null) {
            throw new ServiceRoutingException(CoreMessages.noCatchAllEndpointSet(), message, this.getEndpoint(), session.getService());
        }
        try {
            ImmutableEndpoint endpoint = this.getEndpoint();
            if (this.sendTransformed && endpoint.getTransformers() != null) {
                message.applyTransformers(endpoint.getTransformers());
            }
            DefaultMuleEvent newEvent = new DefaultMuleEvent(message, endpoint, session, synchronous);
            if (synchronous) {
                MuleMessage result = endpoint.send(newEvent);
                if (this.statistics != null) {
                    this.statistics.incrementRoutedMessage(this.getEndpoint());
                }
                return result;
            }
            endpoint.dispatch(newEvent);
            if (this.statistics != null) {
                this.statistics.incrementRoutedMessage(this.getEndpoint());
            }
            return null;
        }
        catch (Exception e) {
            throw new RoutingException(message, this.getEndpoint(), (Throwable)e);
        }
    }

    public boolean isSendTransformed() {
        return this.sendTransformed;
    }

    public void setSendTransformed(boolean sendTransformed) {
        this.sendTransformed = sendTransformed;
    }
}

