/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.seda.optimised;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.ModelException;
import org.mule.api.model.MuleProxy;
import org.mule.api.service.Service;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.stats.ServiceStatistics;
import org.mule.util.queue.QueueSession;

public class OptimisedMuleProxy
implements MuleProxy {
    private static Log logger = LogFactory.getLog(OptimisedMuleProxy.class);
    private MuleEvent event;
    private Service service;
    private boolean suspended = true;
    private ServiceStatistics stat = null;
    private Callable pojoService;
    private boolean started = false;
    private boolean disposed = false;

    public OptimisedMuleProxy(Callable pojoService, Service service) throws MuleException {
        this.service = service;
        this.pojoService = pojoService;
    }

    public void start() throws MuleException {
        this.checkDisposed();
        if (!this.started && this.pojoService instanceof Startable) {
            try {
                ((Startable)((Object)this.pojoService)).start();
                this.started = true;
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStart("Service '" + this.service.getName() + "'"), (Throwable)e);
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() throws MuleException {
        this.checkDisposed();
        if (this.started && this.pojoService instanceof Stoppable) {
            this.started = false;
            try {
                ((Stoppable)((Object)this.pojoService)).stop();
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStop("Service '" + this.service.getName() + "'"), (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.checkDisposed();
        if (this.pojoService instanceof Disposable) {
            ((Disposable)((Object)this.pojoService)).dispose();
            this.disposed = true;
        }
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Components Disposed Of");
        }
    }

    public void onEvent(QueueSession session, MuleEvent event) {
        this.event = event;
    }

    public ServiceStatistics getStatistics() {
        return this.stat;
    }

    public void setStatistics(ServiceStatistics stat) {
        this.stat = stat;
    }

    public Object onCall(MuleEvent event) throws MuleException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MuleProxy: sync call for Mule UMO " + this.service.getName()));
        }
        MuleMessage returnMessage = null;
        try {
            if (event.getEndpoint().isInbound()) {
                long startTime = 0L;
                if (this.stat.isEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                returnMessage = this.invokeUmo(RequestContext.getEventContext());
                if (this.stat.isEnabled()) {
                    this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                }
                if ((event = RequestContext.getEvent()).isStopFurtherProcessing()) {
                    logger.debug((Object)"MuleEvent stop further processing has been set, no outbound routing will be performed.");
                }
                if (returnMessage != null && !event.isStopFurtherProcessing()) {
                    if (this.service.getOutboundRouter().hasEndpoints()) {
                        MuleMessage outboundReturnMessage = this.service.getOutboundRouter().route(returnMessage, event.getSession(), event.isSynchronous());
                        if (outboundReturnMessage != null) {
                            returnMessage = outboundReturnMessage;
                        }
                    } else {
                        logger.debug((Object)("Outbound router on service '" + this.service.getName() + "' doesn't have any endpoints configured."));
                    }
                }
            } else {
                returnMessage = event.getSession().sendEvent(event);
            }
            if (this.stat.isEnabled()) {
                this.stat.incSentEventSync();
            }
        }
        catch (Exception e) {
            event.getSession().setValid(false);
            if (e instanceof MuleException) {
                this.handleException(e);
            }
            this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.service.getName()), event.getMessage(), (Throwable)e));
        }
        return returnMessage;
    }

    protected MuleMessage invokeUmo(MuleEventContext context) throws Exception {
        Object result = this.pojoService.onCall(RequestContext.getEventContext());
        if (result != null) {
            if (result instanceof MuleMessage) {
                return (MuleMessage)result;
            }
            return new DefaultMuleMessage(result, context.getMessage());
        }
        return null;
    }

    public void handleException(Exception exception) {
        this.service.getExceptionListener().exceptionThrown(exception);
    }

    public String toString() {
        return "optimised proxy for: " + this.service.toString();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block12: {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("MuleProxy: async onEvent for Mule UMO " + this.service.getName()));
            }
            try {
                if (this.event.getEndpoint().isInbound()) {
                    this.event = RequestContext.setEvent(this.event);
                    long startTime = 0L;
                    if (this.stat.isEnabled()) {
                        startTime = System.currentTimeMillis();
                    }
                    MuleMessage result = this.invokeUmo(RequestContext.getEventContext());
                    if (this.stat.isEnabled()) {
                        this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                    }
                    this.event = RequestContext.getEvent();
                    if (result != null && !this.event.isStopFurtherProcessing()) {
                        this.service.getOutboundRouter().route(result, this.event.getSession(), this.event.isSynchronous());
                    }
                } else {
                    this.event.getEndpoint().dispatch(this.event);
                }
                if (this.stat.isEnabled()) {
                    this.stat.incSentEventASync();
                }
            }
            catch (Exception e) {
                this.event.getSession().setValid(false);
                if (e instanceof MuleException) {
                    this.handleException(e);
                    break block12;
                }
                this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.service.getName()), this.event.getMessage(), (Throwable)e));
            }
        }
    }

    public void release() {
    }

    public Callable getPojoService() {
        return this.pojoService;
    }
}

