/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.pipeline;

import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.direct.DirectService;

public class PipelineService
extends DirectService {
    private static final long serialVersionUID = -2788210157354765190L;
    private Callable callable;

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        Object component = null;
        try {
            component = this.getOrCreateService();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (!(component instanceof Callable)) {
            throw new InitialisationException(CoreMessages.objectNotOfCorrectType(component.getClass(), Callable.class), (Initialisable)this);
        }
        this.callable = (Callable)component;
        if (component instanceof Initialisable) {
            ((Initialisable)component).initialise();
        }
    }

    protected MuleMessage doSend(MuleEvent event) throws MuleException {
        try {
            Object result = this.callable.onCall(RequestContext.getEventContext());
            MuleMessage returnMessage = null;
            returnMessage = result instanceof MuleMessage ? (MuleMessage)result : new DefaultMuleMessage(result, event.getMessage());
            if (!event.isStopFurtherProcessing()) {
                if (this.outboundRouter.hasEndpoints()) {
                    MuleMessage outboundReturnMessage = this.outboundRouter.route(returnMessage, event.getSession(), event.isSynchronous());
                    if (outboundReturnMessage != null) {
                        returnMessage = outboundReturnMessage;
                    }
                } else {
                    this.logger.debug((Object)("Outbound router on service '" + this.name + "' doesn't have any endpoints configured."));
                }
            }
            return returnMessage;
        }
        catch (Exception e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    protected void doDispatch(MuleEvent event) throws MuleException {
        this.sendEvent(event);
    }

    protected void doDispose() {
        try {
            this.serviceFactory.release(this.callable);
        }
        catch (Exception e) {
            this.logger.warn((Object)e);
        }
    }
}

