/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleAdapterFactory;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.model.Model;
import org.mule.context.notification.ModelNotification;
import org.mule.lifecycle.DefaultLifecycleAdapterFactory;
import org.mule.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.service.DefaultServiceExceptionStrategy;

public abstract class AbstractModel
implements Model {
    public static final String DEFAULT_MODEL_NAME = "main";
    private String name = "main";
    private EntryPointResolverSet entryPointResolverSet = null;
    private LifecycleAdapterFactory lifecycleAdapterFactory = new DefaultLifecycleAdapterFactory();
    private AtomicBoolean initialised = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private ExceptionListener exceptionListener = new DefaultServiceExceptionStrategy();
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleContext muleContext;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EntryPointResolverSet getEntryPointResolverSet() {
        if (null == this.entryPointResolverSet) {
            this.entryPointResolverSet = new LegacyEntryPointResolverSet();
        }
        return this.entryPointResolverSet;
    }

    public void setEntryPointResolverSet(EntryPointResolverSet entryPointResolverSet) {
        this.entryPointResolverSet = entryPointResolverSet;
    }

    public void setEntryPointResolvers(Collection entryPointResolvers) {
        if (null == this.entryPointResolverSet) {
            this.entryPointResolverSet = new DefaultEntryPointResolverSet();
        }
        Iterator resolvers = entryPointResolvers.iterator();
        while (resolvers.hasNext()) {
            this.entryPointResolverSet.addEntryPointResolver((EntryPointResolver)resolvers.next());
        }
    }

    public LifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    public void setLifecycleAdapterFactory(LifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }

    public void dispose() {
        this.fireNotification(new ModelNotification(this, 209));
        this.fireNotification(new ModelNotification(this, 210));
    }

    public void stop() throws MuleException {
        this.fireNotification(new ModelNotification(this, 207));
        this.started.set(false);
        this.fireNotification(new ModelNotification(this, 208));
    }

    public void start() throws MuleException {
        if (!this.initialised.get()) {
            throw new IllegalStateException("Not Initialised");
        }
        if (!this.started.get()) {
            this.fireNotification(new ModelNotification(this, 205));
            this.started.set(true);
            this.fireNotification(new ModelNotification(this, 206));
        } else {
            this.logger.debug((Object)"Model already started");
        }
    }

    public void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            this.fireNotification(new ModelNotification(this, 201));
            this.initialised.set(true);
            this.fireNotification(new ModelNotification(this, 202));
        } else {
            this.logger.debug((Object)"Model already initialised");
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    void fireNotification(ServerNotification notification) {
        if (this.muleContext != null) {
            this.muleContext.fireNotification(notification);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MuleContext is not yet available for firing notifications, ignoring event: " + notification));
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

