/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.ConnectionStrategy;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.config.MuleManifest;
import org.mule.transformer.TransformerUtils;
import org.mule.util.ClassUtils;

public abstract class ImmutableMuleEndpoint
implements ImmutableEndpoint {
    private static final long serialVersionUID = -1650380871293160973L;
    protected static final Log logger = LogFactory.getLog(ImmutableMuleEndpoint.class);
    protected Connector connector = null;
    protected EndpointURI endpointUri = null;
    protected AtomicReference transformers = new AtomicReference((Object)TransformerUtils.UNDEFINED);
    protected AtomicReference responseTransformers = new AtomicReference((Object)TransformerUtils.UNDEFINED);
    protected String name = null;
    protected Map properties = new HashMap();
    protected TransactionConfig transactionConfig = null;
    protected Filter filter = null;
    protected boolean deleteUnacceptedMessages = false;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected EndpointSecurityFilter securityFilter = null;
    protected boolean synchronous;
    protected boolean remoteSync;
    protected Integer remoteSyncTimeout = null;
    protected String initialState = "started";
    protected String endpointEncoding;
    protected String registryId = null;
    protected MuleContext muleContext;
    protected ConnectionStrategy connectionStrategy;

    protected ImmutableMuleEndpoint() {
    }

    public EndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    public String getEncoding() {
        return this.endpointEncoding;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public String getName() {
        return this.name;
    }

    public List getTransformers() {
        return (List)this.transformers.get();
    }

    public Map getProperties() {
        return this.properties;
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        String sanitizedEndPointUri = null;
        URI uri = null;
        if (this.endpointUri != null) {
            sanitizedEndPointUri = this.endpointUri.toString();
            uri = this.endpointUri.getUri();
        }
        if (uri != null && uri.getRawUserInfo() != null && uri.getScheme() != null && uri.getHost() != null && uri.getRawPath() != null) {
            Pattern sanitizerPattern = Pattern.compile("(.*):.*");
            Matcher sanitizerMatcher = sanitizerPattern.matcher(uri.getRawUserInfo());
            if (sanitizerMatcher.matches()) {
                sanitizedEndPointUri = new StringBuffer(uri.getScheme()).append("://").append(sanitizerMatcher.group(1)).append(":<password>").append("@").append(uri.getHost()).append(uri.getRawPath()).toString();
            }
            if (uri.getRawQuery() != null) {
                sanitizedEndPointUri = sanitizedEndPointUri + "?" + uri.getRawQuery();
            }
        }
        return ClassUtils.getClassName(this.getClass()) + "{endpointUri=" + sanitizedEndPointUri + ", connector=" + this.connector + ", transformer=" + this.transformers.get() + ", name='" + this.name + "'" + ", isInbound=" + this.isInbound() + ", isOutbound=" + this.isOutbound() + ", properties=" + this.properties + ", transactionConfig=" + this.transactionConfig + ", filter=" + this.filter + ", deleteUnacceptedMessages=" + this.deleteUnacceptedMessages + ", initialised=" + this.initialised + ", securityFilter=" + this.securityFilter + ", synchronous=" + this.synchronous + ", initialState=" + this.initialState + ", remoteSync=" + this.remoteSync + ", remoteSyncTimeout=" + this.remoteSyncTimeout + ", endpointEncoding=" + this.endpointEncoding + "}";
    }

    public String getProtocol() {
        return this.connector.getProtocol();
    }

    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableMuleEndpoint)) {
            return false;
        }
        ImmutableMuleEndpoint immutableMuleProviderDescriptor = (ImmutableMuleEndpoint)o;
        if (!this.connector.getName().equals(immutableMuleProviderDescriptor.connector.getName())) {
            return false;
        }
        if (this.endpointUri != null && immutableMuleProviderDescriptor.endpointUri != null ? !this.endpointUri.getAddress().equals(immutableMuleProviderDescriptor.endpointUri.getAddress()) : immutableMuleProviderDescriptor.endpointUri != null) {
            return false;
        }
        if (!this.name.equals(immutableMuleProviderDescriptor.name)) {
            return false;
        }
        return this.isInbound() == immutableMuleProviderDescriptor.isInbound() && this.isOutbound() == immutableMuleProviderDescriptor.isOutbound();
    }

    public int hashCode() {
        int result = this.appendHash(0, this.connector);
        result = this.appendHash(result, this.endpointUri);
        result = this.appendHash(result, this.name);
        result = this.appendHash(result, this.isInbound());
        result = this.appendHash(result, this.isOutbound());
        return result;
    }

    private int appendHash(int hash, Object component) {
        int delta = component != null ? component.hashCode() : 0;
        return 29 * hash + delta;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean isDeleteUnacceptedMessages() {
        return this.deleteUnacceptedMessages;
    }

    protected void setTransformersIfUndefined(AtomicReference reference, List transformers) {
        TransformerUtils.discourageNullTransformers(transformers);
        if (transformers.size() == 0) {
            transformers = TransformerUtils.UNDEFINED;
        }
        reference.compareAndSet((Object)TransformerUtils.UNDEFINED, (Object)transformers);
        this.updateTransformerEndpoints(reference);
    }

    protected void updateTransformerEndpoints(AtomicReference reference) {
        List transformers = (List)reference.get();
        if (TransformerUtils.isDefined(transformers)) {
            Iterator transformer = transformers.iterator();
            while (transformer.hasNext()) {
                ((Transformer)transformer.next()).setEndpoint(this);
            }
        }
    }

    public EndpointSecurityFilter getSecurityFilter() {
        return this.securityFilter;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public boolean isRemoteSync() {
        return this.remoteSync;
    }

    public int getRemoteSyncTimeout() {
        if (this.remoteSyncTimeout == null) {
            this.remoteSyncTimeout = new Integer(0);
        }
        return this.remoteSyncTimeout;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public List getResponseTransformers() {
        return (List)this.responseTransformers.get();
    }

    public Object getProperty(Object key) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = this.endpointUri.getParams().get(key);
        }
        return value;
    }

    public void dispatch(MuleEvent event) throws DispatchException {
        if (this.connector == null) {
            throw new IllegalStateException("The connector on the endpoint: " + this.toString() + " is null. Please contact " + MuleManifest.getDevListEmail());
        }
        this.connector.dispatch(this, event);
    }

    public MuleMessage request(long timeout) throws Exception {
        if (this.connector != null) {
            return this.connector.request(this, timeout);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + " is null. Please contact " + MuleManifest.getDevListEmail());
    }

    public MuleMessage send(MuleEvent event) throws DispatchException {
        if (this.connector != null) {
            return this.connector.send(this, event);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + " is null. Please contact " + MuleManifest.getDevListEmail());
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void initialise() throws InitialisationException {
    }
}

