/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mule.RegistryContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.ServiceException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.ConnectionStrategy;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.endpoint.InboundEndpoint;
import org.mule.endpoint.MuleEndpoint;
import org.mule.endpoint.OutboundEndpoint;
import org.mule.endpoint.URIBuilder;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.AbstractConnector;
import org.mule.transport.SingleAttemptConnectionStrategy;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.service.TransportFactoryException;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.ClassUtils;
import org.mule.util.MapCombiner;
import org.mule.util.ObjectNameHelper;

public abstract class AbstractEndpointBuilder
implements EndpointBuilder {
    public static final int GET_OR_CREATE_CONNECTOR = 0;
    public static final int ALWAYS_CREATE_CONNECTOR = 1;
    public static final int NEVER_CREATE_CONNECTOR = 2;
    public static final int USE_CONNECTOR = 3;
    protected URIBuilder uriBuilder;
    protected Connector connector;
    protected List transformers = TransformerUtils.UNDEFINED;
    protected List responseTransformers = TransformerUtils.UNDEFINED;
    protected String name;
    protected Map properties = new HashMap();
    protected TransactionConfig transactionConfig;
    protected Filter filter;
    protected Boolean deleteUnacceptedMessages;
    protected EndpointSecurityFilter securityFilter;
    protected Boolean synchronous;
    protected Boolean remoteSync;
    protected Integer remoteSyncTimeout;
    protected String initialState = "started";
    protected String encoding;
    protected Integer createConnector;
    protected ConnectionStrategy connectionStrategy;
    protected String registryId = null;
    protected MuleContext muleContext;

    public ImmutableEndpoint buildInboundEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildInboundEndpoint();
    }

    public ImmutableEndpoint buildOutboundEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildOutboundEndpoint();
    }

    protected void configureEndpoint(MuleEndpoint ep) throws InitialisationException, EndpointException {
        EndpointURI endpointURI = this.uriBuilder.getEndpoint();
        endpointURI.initialise();
        ep.setEndpointURI(endpointURI);
        Connector connector = this.getConnector();
        ep.setConnector(connector);
        ep.setSecurityFilter(this.getSecurityFilter());
        ep.setTransactionConfig(this.getTransactionConfig());
        ep.setProperties(this.getProperties());
        ep.setName(this.getName(ep));
        ep.setConnectionStrategy(this.getConnectionStrategy(connector));
        ep.setDeleteUnacceptedMessages(this.getDeleteUnacceptedMessages(connector));
        ep.setEncoding(this.getEndpointEncoding(connector));
        ep.setFilter(this.getFilter(connector));
        ep.setInitialState(this.getInitialState(connector));
        ep.setRemoteSyncTimeout(this.getRemoteSyncTimeout(connector));
        boolean remoteSync = this.getRemoteSync(connector);
        ep.setRemoteSync(remoteSync);
        if (remoteSync) {
            ep.setSynchronous(true);
        } else {
            ep.setSynchronous(this.getSynchronous(connector, ep));
        }
        ep.setMuleContext(this.muleContext);
    }

    protected ImmutableEndpoint doBuildInboundEndpoint() throws InitialisationException, EndpointException {
        InboundEndpoint ep = new InboundEndpoint();
        this.configureEndpoint(ep);
        ep.setTransformers(this.getInboundTransformers(ep.getConnector(), ep.getEndpointURI()));
        ep.setResponseTransformers(this.getResponseTransformers(ep.getConnector(), ep.getEndpointURI()));
        return ep;
    }

    protected ImmutableEndpoint doBuildOutboundEndpoint() throws InitialisationException, EndpointException {
        OutboundEndpoint ep = new OutboundEndpoint();
        this.configureEndpoint(ep);
        ep.setTransformers(this.getOutboundTransformers(ep.getConnector(), ep.getEndpointURI()));
        ep.setResponseTransformers(this.getResponseTransformers(ep.getConnector(), ep.getEndpointURI()));
        return ep;
    }

    protected boolean getSynchronous(Connector connector, ImmutableEndpoint endpoint) {
        return this.synchronous != null ? this.synchronous.booleanValue() : this.getDefaultSynchronous(connector, endpoint);
    }

    protected boolean getDefaultSynchronous(Connector connector, ImmutableEndpoint endpoint) {
        if (connector != null && connector.isSyncEnabled(endpoint)) {
            return true;
        }
        return RegistryContext.getConfiguration().isDefaultSynchronousEndpoints();
    }

    protected ConnectionStrategy getConnectionStrategy(Connector connector) {
        return this.connectionStrategy != null ? this.connectionStrategy : this.getDefaultConnectionStrategy(connector);
    }

    protected ConnectionStrategy getDefaultConnectionStrategy(Connector connector) {
        return new SingleAttemptConnectionStrategy();
    }

    protected TransactionConfig getTransactionConfig() {
        return this.transactionConfig != null ? this.transactionConfig : this.getDefaultTransactionConfig();
    }

    protected TransactionConfig getDefaultTransactionConfig() {
        return new MuleTransactionConfig();
    }

    protected EndpointSecurityFilter getSecurityFilter() {
        return this.securityFilter != null ? this.securityFilter : this.getDefaultSecurityFilter();
    }

    protected EndpointSecurityFilter getDefaultSecurityFilter() {
        return null;
    }

    protected Connector getConnector() throws EndpointException {
        return this.connector != null ? this.connector : this.getDefaultConnector();
    }

    protected Connector getDefaultConnector() throws EndpointException {
        return this.getConnector(this.uriBuilder.getEndpoint(), this.muleContext);
    }

    protected String getName(ImmutableEndpoint endpoint) {
        return this.name != null ? this.name : ObjectNameHelper.getEndpointName(endpoint);
    }

    protected Map getProperties() {
        LinkedList<Map> maps = new LinkedList<Map>();
        if (null != this.uriBuilder) {
            maps.addLast(this.uriBuilder.getEndpoint().getParams());
        }
        if (this.properties != null) {
            maps.addLast(this.properties);
        }
        MapCombiner combiner = new MapCombiner();
        combiner.setList(maps);
        return Collections.unmodifiableMap(combiner);
    }

    protected boolean getRemoteSync(Connector connector) {
        return this.remoteSync != null ? this.remoteSync.booleanValue() : this.getDefaultRemoteSync(connector);
    }

    protected boolean getDefaultRemoteSync(Connector connector) {
        if (connector == null || connector.isRemoteSyncEnabled()) {
            return false;
        }
        return false;
    }

    protected boolean getDeleteUnacceptedMessages(Connector connector) {
        return this.deleteUnacceptedMessages != null ? this.deleteUnacceptedMessages.booleanValue() : this.getDefaultDeleteUnacceptedMessages(connector);
    }

    protected boolean getDefaultDeleteUnacceptedMessages(Connector connector) {
        return false;
    }

    protected String getEndpointEncoding(Connector connector) {
        return this.encoding != null ? this.encoding : this.getDefaultEndpointEncoding(connector);
    }

    protected String getDefaultEndpointEncoding(Connector connector) {
        if (this.muleContext != null) {
            return this.muleContext.getRegistry().getConfiguration().getDefaultEncoding();
        }
        return System.getProperty("file.encoding");
    }

    protected Filter getFilter(Connector connector) {
        return this.filter != null ? this.filter : this.getDefaultFilter(connector);
    }

    protected Filter getDefaultFilter(Connector connector) {
        return null;
    }

    protected String getInitialState(Connector connector) {
        return this.initialState != null ? this.initialState : this.getDefaultInitialState(connector);
    }

    protected String getDefaultInitialState(Connector connector) {
        return "started";
    }

    protected int getRemoteSyncTimeout(Connector connector) {
        return this.remoteSyncTimeout != null ? this.remoteSyncTimeout.intValue() : this.getDefaultRemoteSyncTimeout(connector);
    }

    protected int getDefaultRemoteSyncTimeout(Connector connector) {
        return this.muleContext.getRegistry().getConfiguration().getDefaultSynchronousEventTimeout();
    }

    protected List getInboundTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (TransformerUtils.isDefined(this.transformers)) {
            return this.transformers;
        }
        List transformers = this.getTransformersFromString(endpointURI.getTransformers());
        if (TransformerUtils.isDefined(transformers)) {
            return transformers;
        }
        return this.getDefaultInboundTransformers(connector);
    }

    protected List getDefaultInboundTransformers(Connector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultInboundTransformers(this.getNonNullServiceDescriptor(this.uriBuilder.getEndpoint().getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    protected List getOutboundTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (TransformerUtils.isDefined(this.transformers)) {
            return this.transformers;
        }
        List transformers = this.getTransformersFromString(endpointURI.getTransformers());
        if (TransformerUtils.isDefined(transformers)) {
            return transformers;
        }
        return this.getDefaultOutboundTransformers(connector);
    }

    protected List getDefaultOutboundTransformers(Connector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultOutboundTransformers(this.getNonNullServiceDescriptor(this.uriBuilder.getEndpoint().getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    protected List getResponseTransformers(Connector connector, EndpointURI endpointURI) throws TransportFactoryException {
        if (TransformerUtils.isDefined(this.responseTransformers)) {
            return this.responseTransformers;
        }
        List transformers = this.getTransformersFromString(endpointURI.getResponseTransformers());
        if (TransformerUtils.isDefined(transformers)) {
            return transformers;
        }
        return this.getDefaultResponseTransformers(connector);
    }

    protected List getDefaultResponseTransformers(Connector connector) throws TransportFactoryException {
        try {
            return TransformerUtils.getDefaultResponseTransformers(this.getNonNullServiceDescriptor(this.uriBuilder.getEndpoint().getSchemeMetaInfo(), this.getOverrides(connector)));
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    private List getTransformersFromString(String transformers) throws TransportFactoryException {
        try {
            return TransformerUtils.getTransformers(transformers);
        }
        catch (DefaultMuleException e) {
            throw new TransportFactoryException(e);
        }
    }

    private Properties getOverrides(Connector connector) {
        Map so;
        Properties overrides = new Properties();
        if (connector instanceof AbstractConnector && (so = ((AbstractConnector)connector).getServiceOverrides()) != null) {
            overrides.putAll((Map<?, ?>)so);
        }
        return overrides;
    }

    private TransportServiceDescriptor getNonNullServiceDescriptor(String scheme, Properties overrides) throws ServiceException {
        TransportServiceDescriptor sd = (TransportServiceDescriptor)RegistryContext.getRegistry().lookupServiceDescriptor("transport", scheme, overrides);
        if (null != sd) {
            return sd;
        }
        throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
    }

    private Connector getConnector(EndpointURI endpointURI, MuleContext muleContext) throws EndpointException {
        Connector connector;
        String scheme = this.uriBuilder.getEndpoint().getFullScheme();
        try {
            if (this.uriBuilder.getEndpoint().getConnectorName() != null) {
                connector = muleContext.getRegistry().lookupConnector(this.uriBuilder.getEndpoint().getConnectorName());
                if (connector == null) {
                    throw new TransportFactoryException(CoreMessages.objectNotRegistered("Connector", this.uriBuilder.getEndpoint().getConnectorName()));
                }
            } else {
                connector = TransportFactory.getConnectorByProtocol(scheme);
                if (connector == null) {
                    connector = TransportFactory.createConnector(endpointURI, muleContext);
                    muleContext.getRegistry().registerConnector(connector);
                }
            }
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
        if (connector == null) {
            Message m = CoreMessages.failedToCreateObjectWith("Endpoint", "endpointURI: " + endpointURI);
            m.setNextMessage(CoreMessages.objectIsNull("connector"));
            throw new TransportFactoryException(m);
        }
        return connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void addTransformer(Transformer transformer) {
        if (this.transformers == TransformerUtils.UNDEFINED) {
            this.transformers = new ArrayList();
        }
        this.transformers.add(transformer);
    }

    public void setTransformers(List transformers) {
        this.transformers = transformers;
    }

    public void setResponseTransformers(List responseTransformers) {
        this.responseTransformers = responseTransformers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map properties) {
        if (null == this.properties) {
            this.properties = new HashMap();
        }
        this.properties.putAll(properties);
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setDeleteUnacceptedMessages(boolean deleteUnacceptedMessages) {
        this.deleteUnacceptedMessages = new Boolean(deleteUnacceptedMessages);
    }

    public void setSecurityFilter(EndpointSecurityFilter securityFilter) {
        this.securityFilter = securityFilter;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = new Boolean(synchronous);
    }

    public void setRemoteSync(boolean remoteSync) {
        this.remoteSync = new Boolean(remoteSync);
    }

    public void setRemoteSyncTimeout(int remoteSyncTimeout) {
        this.remoteSyncTimeout = new Integer(remoteSyncTimeout);
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCreateConnector(int createConnector) {
        this.createConnector = new Integer(createConnector);
    }

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public URIBuilder getEndpointBuilder() {
        return this.uriBuilder;
    }

    public void setURIBuilder(URIBuilder URIBuilder2) {
        this.uriBuilder = URIBuilder2;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connectionStrategy == null ? 0 : this.connectionStrategy.hashCode());
        result = 31 * result + (this.connector == null ? 0 : this.connector.hashCode());
        result = 31 * result + (this.createConnector == null ? 0 : this.createConnector.hashCode());
        result = 31 * result + (this.deleteUnacceptedMessages == null ? 0 : this.deleteUnacceptedMessages.hashCode());
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.uriBuilder == null ? 0 : this.uriBuilder.getEndpoint().hashCode());
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.initialState == null ? 0 : this.initialState.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : ((Object)this.properties).hashCode());
        result = 31 * result + (this.remoteSync == null ? 0 : this.remoteSync.hashCode());
        result = 31 * result + (this.remoteSyncTimeout == null ? 0 : this.remoteSyncTimeout.hashCode());
        result = 31 * result + (this.responseTransformers == null ? 0 : ((Object)this.responseTransformers).hashCode());
        result = 31 * result + (this.securityFilter == null ? 0 : this.securityFilter.hashCode());
        result = 31 * result + (this.synchronous == null ? 0 : this.synchronous.hashCode());
        result = 31 * result + (this.transactionConfig == null ? 0 : this.transactionConfig.hashCode());
        result = 31 * result + (this.transformers == null ? 0 : ((Object)this.transformers).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEndpointBuilder other = (AbstractEndpointBuilder)obj;
        return AbstractEndpointBuilder.equal(this.connectionStrategy, other.connectionStrategy) && AbstractEndpointBuilder.equal(this.connector, other.connector) && AbstractEndpointBuilder.equal(this.createConnector, other.createConnector) && AbstractEndpointBuilder.equal(this.deleteUnacceptedMessages, other.deleteUnacceptedMessages) && AbstractEndpointBuilder.equal(this.encoding, other.encoding) && AbstractEndpointBuilder.equal(this.uriBuilder, other.uriBuilder) && AbstractEndpointBuilder.equal(this.filter, other.filter) && AbstractEndpointBuilder.equal(this.initialState, other.initialState) && AbstractEndpointBuilder.equal(this.name, other.name) && AbstractEndpointBuilder.equal(this.properties, other.properties) && AbstractEndpointBuilder.equal(this.remoteSync, other.remoteSync) && AbstractEndpointBuilder.equal(this.remoteSyncTimeout, other.remoteSyncTimeout) && AbstractEndpointBuilder.equal(this.responseTransformers, other.responseTransformers) && AbstractEndpointBuilder.equal(this.securityFilter, other.securityFilter) && AbstractEndpointBuilder.equal(this.synchronous, other.synchronous) && AbstractEndpointBuilder.equal(this.transactionConfig, other.transactionConfig) && AbstractEndpointBuilder.equal(this.transformers, other.transformers);
    }

    protected static boolean equal(Object a, Object b) {
        return ClassUtils.equal(a, b);
    }

    public Object clone() throws CloneNotSupportedException {
        EndpointBuilder builder = (EndpointBuilder)super.clone();
        builder.setConnector(this.connector);
        builder.setURIBuilder(this.uriBuilder);
        builder.setTransformers(this.transformers);
        builder.setResponseTransformers(this.responseTransformers);
        builder.setName(this.name);
        builder.setProperties(this.properties);
        builder.setTransactionConfig(this.transactionConfig);
        builder.setFilter(this.filter);
        builder.setSecurityFilter(this.securityFilter);
        builder.setInitialState(this.initialState);
        builder.setEncoding(this.encoding);
        builder.setRegistryId(this.registryId);
        builder.setMuleContext(this.muleContext);
        builder.setConnectionStrategy(this.connectionStrategy);
        if (this.deleteUnacceptedMessages != null) {
            builder.setDeleteUnacceptedMessages(this.deleteUnacceptedMessages);
        }
        if (this.synchronous != null) {
            builder.setSynchronous(this.synchronous);
        }
        if (this.remoteSync != null) {
            builder.setRemoteSync(this.remoteSync);
        }
        if (this.remoteSyncTimeout != null) {
            builder.setRemoteSyncTimeout(this.remoteSyncTimeout);
        }
        return builder;
    }
}

