/*
 * Decompiled with CFR 0.152.
 */
package org.mule.container;

import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.mule.api.context.ContainerException;
import org.mule.api.context.ObjectNotFoundException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.container.AbstractContainerContext;
import org.mule.util.TemplateParser;

public class PropertiesContainerContext
extends AbstractContainerContext
implements TemplateParser.TemplateCallback {
    protected Map systemProperties;
    protected Map properties;
    protected boolean includeSystemProperties = true;
    protected boolean enableTemplates = false;
    protected TemplateParser templateParser = TemplateParser.createAntStyleParser();

    public PropertiesContainerContext() {
        super("properties");
    }

    public void initialise() throws InitialisationException {
        if (this.properties != null) {
            for (Map.Entry entry : this.properties.entrySet()) {
                String value = entry.getValue().toString();
                value = this.templateParser.parse((TemplateParser.TemplateCallback)this, value);
                try {
                    this.muleContext.getRegistry().registerObject(entry.getKey().toString(), value, this.muleContext);
                }
                catch (RegistrationException e) {
                    throw new InitialisationException((Throwable)e, (Initialisable)this);
                }
            }
        }
        this.setSystemProperties(null);
    }

    public Object match(String token) {
        return this.muleContext.getRegistry().lookupObject(token);
    }

    public void configure(Reader configuration) throws ContainerException {
        throw new UnsupportedOperationException("configure");
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        if (key == null) {
            throw new ObjectNotFoundException("null");
        }
        Object value = this.muleContext.getRegistry().lookupObject(key.toString());
        if (value == null) {
            throw new ObjectNotFoundException(key.toString());
        }
        if (value instanceof String && this.enableTemplates) {
            value = this.templateParser.parse(this.properties, value.toString());
        }
        return value;
    }

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map properties) {
        String value;
        this.systemProperties = properties;
        if (this.systemProperties != null) {
            for (Map.Entry entry : this.systemProperties.entrySet()) {
                value = entry.getValue().toString();
                value = this.templateParser.parse(this.systemProperties, value);
                value = this.templateParser.parse((TemplateParser.TemplateCallback)this, value);
                System.setProperty(entry.getKey().toString(), value);
            }
        }
        if (this.includeSystemProperties) {
            Properties props = System.getProperties();
            for (Map.Entry entry : props.entrySet()) {
                value = entry.getValue().toString();
                value = this.templateParser.parse((TemplateParser.TemplateCallback)this, value.toString());
                try {
                    this.muleContext.getRegistry().registerObject(entry.getKey().toString(), value, this.muleContext);
                }
                catch (RegistrationException e) {
                    this.logger.error((Object)e);
                }
            }
        }
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public boolean isIncludeSystemProperties() {
        return this.includeSystemProperties;
    }

    public void setIncludeSystemProperties(boolean includeSystemProperties) {
        this.includeSystemProperties = includeSystemProperties;
    }

    public boolean isEnableTemplates() {
        return this.enableTemplates;
    }

    public void setEnableTemplates(boolean enableTemplates) {
        this.enableTemplates = enableTemplates;
    }
}

