/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.registry.Registry;
import org.mule.config.ChainedThreadingProfile;
import org.mule.config.bootstrap.SimpleRegistryBootstrap;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.endpoint.DefaultEndpointFactory;
import org.mule.model.seda.SedaModel;
import org.mule.security.MuleSecurityManager;
import org.mule.util.queue.CachingPersistenceStrategy;
import org.mule.util.queue.MemoryPersistenceStrategy;
import org.mule.util.queue.TransactionalQueueManager;

public class DefaultsConfigurationBuilder
extends AbstractConfigurationBuilder {
    protected void doConfigure(MuleContext muleContext) throws Exception {
        this.configureDefaults(muleContext.getRegistry());
    }

    protected void configureDefaults(Registry registry) throws MuleException {
        registry.registerObject("_muleSimpleRegistryBootstrap", new SimpleRegistryBootstrap());
        TransactionalQueueManager queueManager = new TransactionalQueueManager();
        queueManager.setPersistenceStrategy(new CachingPersistenceStrategy(new MemoryPersistenceStrategy()));
        registry.registerObject("_muleQueueManager", queueManager);
        registry.registerObject("_muleSecurityManager", new MuleSecurityManager());
        registry.registerObject("_muleEndpointFactory", new DefaultEndpointFactory());
        ChainedThreadingProfile defaultThreadingProfile = new ChainedThreadingProfile();
        defaultThreadingProfile.setThreadWaitTimeout(30L);
        defaultThreadingProfile.setMaxThreadsActive(10);
        defaultThreadingProfile.setMaxThreadsIdle(10);
        defaultThreadingProfile.setMaxBufferSize(0);
        defaultThreadingProfile.setThreadTTL(60000L);
        defaultThreadingProfile.setPoolExhaustedAction(4);
        registry.registerObject("_defaultThreadingProfile", defaultThreadingProfile);
        registry.registerObject("_defaultMessageReceiverThreadingProfile", new ChainedThreadingProfile(defaultThreadingProfile));
        registry.registerObject("_defaultMessageRequesterThreadingProfile", new ChainedThreadingProfile(defaultThreadingProfile));
        registry.registerObject("_defaultMessageDispatcherThreadingProfile", new ChainedThreadingProfile(defaultThreadingProfile));
        registry.registerObject("_defaultComponentThreadingProfile", new ChainedThreadingProfile(defaultThreadingProfile));
        SedaModel systemModel = new SedaModel();
        systemModel.setName("_muleSystemModel");
        registry.registerModel(systemModel);
    }
}

