/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;

public class AutoConfigurationBuilder
extends AbstractResourceConfigurationBuilder {
    protected static final Log logger = LogFactory.getLog(AutoConfigurationBuilder.class);

    public AutoConfigurationBuilder(String resource) {
        super(resource);
    }

    protected void doConfigure(MuleContext muleContext) throws ConfigurationException {
        this.autoConfigure(muleContext, this.configResources);
    }

    protected void autoConfigure(MuleContext muleContext, String[] configResources) throws ConfigurationException {
        ConfigurationBuilder configurationBuilder = null;
        if (ClassUtils.isClassOnPath("org.mule.config.spring.SpringXmlConfigurationBuilder", this.getClass())) {
            try {
                configurationBuilder = (ConfigurationBuilder)ClassUtils.instanciateClass("org.mule.config.spring.SpringXmlConfigurationBuilder", new Object[]{configResources});
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        } else if (ClassUtils.isClassOnPath("org.mule.config.scripting.ScriptingConfigurationBuilder", this.getClass())) {
            try {
                configurationBuilder = (ConfigurationBuilder)ClassUtils.instanciateClass("org.mule.config.spring.SpringXmlConfigurationBuilder", new Object[]{configResources});
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        } else {
            throw new ConfigurationException(CoreMessages.configurationBuilderNoMatching(this.createConfigResourcesString()));
        }
        configurationBuilder.configure(muleContext);
    }
}

