/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component.builder;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.component.builder.MessageBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Callable;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceAware;
import org.mule.util.StringMessageUtils;

public abstract class AbstractMessageBuilder
implements ServiceAware,
Callable,
MessageBuilder {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected Service service;

    public void setService(Service service) throws ConfigurationException {
        this.service = service;
    }

    public Object onCall(MuleEventContext eventContext) throws Exception {
        DefaultMuleMessage requestMessage = new DefaultMuleMessage(eventContext.transformMessage(), eventContext.getMessage());
        MuleMessage responseMessage = null;
        if (this.service.getOutboundRouter().hasEndpoints()) {
            ArrayList endpoints = new ArrayList();
            for (OutboundRouter router : this.service.getOutboundRouter().getRouters()) {
                endpoints.addAll(router.getEndpoints());
            }
            for (ImmutableEndpoint endpoint : endpoints) {
                Object request = requestMessage.getPayload();
                boolean rsync = eventContext.getMessage().getBooleanProperty("MULE_REMOTE_SYNC", endpoint.isRemoteSync());
                if (!rsync) {
                    this.logger.info((Object)("Endpoint: " + endpoint + " is not remoteSync enabled. Message builder finishing"));
                    if (eventContext.isSynchronous()) {
                        responseMessage = eventContext.sendEvent((MuleMessage)requestMessage, endpoint);
                    } else {
                        eventContext.dispatchEvent((MuleMessage)requestMessage, endpoint);
                        responseMessage = null;
                    }
                    break;
                }
                responseMessage = eventContext.sendEvent((MuleMessage)requestMessage, endpoint);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Response Message Received from: " + endpoint.getEndpointURI()));
                }
                if (this.logger.isTraceEnabled()) {
                    try {
                        this.logger.trace((Object)("Message Payload: \n" + StringMessageUtils.truncate(StringMessageUtils.toString(responseMessage.getPayload()), 200, false)));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                Object builtMessage = this.buildMessage(new DefaultMuleMessage(request, requestMessage), responseMessage);
                responseMessage = new DefaultMuleMessage(builtMessage, responseMessage);
                requestMessage = new DefaultMuleMessage(responseMessage.getPayload(), responseMessage);
            }
        } else {
            this.logger.info((Object)("There are currently no endpoints configured on service: " + this.service.getName()));
        }
        eventContext.setStopFurtherProcessing(true);
        return responseMessage;
    }
}

