/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.LifecycleAdapter;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.model.Model;
import org.mule.api.model.ModelException;
import org.mule.api.model.MuleProxy;
import org.mule.api.service.Service;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.stats.ServiceStatistics;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transport.AbstractConnector;
import org.mule.transport.NullPayload;
import org.mule.util.queue.QueueSession;

public class DefaultMuleProxy
implements MuleProxy {
    private static Log logger = LogFactory.getLog(DefaultMuleProxy.class);
    private MuleEvent event;
    private LifecycleAdapter umo;
    private Service service;
    private boolean suspended = true;
    private ServiceStatistics stat = null;
    private QueueSession queueSession = null;
    protected MuleContext muleContext;

    public DefaultMuleProxy(Object pojoService, Service service, MuleContext muleContext) throws MuleException {
        this.service = service;
        this.muleContext = muleContext;
        Model model = service.getModel();
        EntryPointResolverSet resolver = model.getEntryPointResolverSet();
        this.umo = model.getLifecycleAdapterFactory().create(pojoService, service, resolver);
    }

    public void start() throws MuleException {
        this.checkDisposed();
        if (!this.umo.isStarted()) {
            try {
                this.umo.start();
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStart("Service '" + this.service.getName() + "'"), (Throwable)e);
            }
        }
    }

    public boolean isStarted() {
        return this.umo.isStarted();
    }

    public void stop() throws MuleException {
        this.checkDisposed();
        if (this.umo.isStarted()) {
            try {
                this.umo.stop();
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStop("Service '" + this.service.getName() + "'"), (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.checkDisposed();
    }

    private void checkDisposed() {
        if (this.umo.isDisposed()) {
            throw new IllegalStateException("Service has already been disposed of");
        }
    }

    public void onEvent(QueueSession session, MuleEvent event) {
        this.queueSession = session;
        this.event = event;
    }

    public ServiceStatistics getStatistics() {
        return this.stat;
    }

    public void setStatistics(ServiceStatistics stat) {
        this.stat = stat;
    }

    public Object onCall(MuleEvent event) throws MuleException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MuleProxy: sync call for Mule UMO " + this.service.getName()));
        }
        MuleMessage returnMessage = null;
        try {
            if (event.getEndpoint().isInbound()) {
                String requestor;
                event = OptimizedRequestContext.unsafeSetEvent(event);
                Object replyTo = event.getMessage().getReplyTo();
                ReplyToHandler replyToHandler = this.getReplyToHandler(event.getMessage(), event.getEndpoint());
                long startTime = 0L;
                if (this.stat.isEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                if (this.service.getName().startsWith("_xfireServiceComponent") || this.service.getName().startsWith("_axisServiceComponent")) {
                    event.getMessage().setBooleanProperty("MULE_IGNORE_METHOD", true);
                }
                returnMessage = this.umo.intercept(null);
                if (this.service.getName().startsWith("_xfireServiceComponent") || this.service.getName().startsWith("_axisServiceComponent")) {
                    returnMessage.removeProperty("MULE_IGNORE_METHOD");
                }
                if (this.stat.isEnabled()) {
                    this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                }
                if (event.isStopFurtherProcessing()) {
                    logger.debug((Object)"MuleEvent stop further processing has been set, no outbound routing will be performed.");
                }
                if (returnMessage != null && !event.isStopFurtherProcessing()) {
                    if (this.service.getOutboundRouter().hasEndpoints()) {
                        MuleMessage outboundReturnMessage = this.service.getOutboundRouter().route(returnMessage, event.getSession(), event.isSynchronous());
                        if (outboundReturnMessage != null) {
                            returnMessage = outboundReturnMessage;
                        }
                    } else {
                        logger.debug((Object)("Outbound router on service '" + this.service.getName() + "' doesn't have any endpoints configured."));
                    }
                }
                if (returnMessage != null && this.service.getResponseRouter() != null) {
                    logger.debug((Object)"Waiting for response router message");
                    returnMessage = this.service.getResponseRouter().getResponse(returnMessage);
                }
                if (returnMessage != null && replyToHandler != null && ((requestor = (String)returnMessage.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.service.getName()) || requestor == null)) {
                    replyToHandler.processReplyTo(event, returnMessage, replyTo);
                }
            } else {
                returnMessage = event.getSession().sendEvent(event);
                this.processReplyTo(returnMessage);
            }
            if (this.stat.isEnabled()) {
                this.stat.incSentEventSync();
            }
        }
        catch (Exception e) {
            ExceptionPayload exceptionPayload;
            event.getSession().setValid(false);
            if (e instanceof MessagingException) {
                this.handleException(e);
            } else {
                this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.service.getName()), event.getMessage(), (Throwable)e));
            }
            if (returnMessage == null) {
                returnMessage = new DefaultMuleMessage((Object)NullPayload.getInstance(), RequestContext.getEvent().getMessage());
            }
            if ((exceptionPayload = returnMessage.getExceptionPayload()) == null) {
                exceptionPayload = new DefaultExceptionPayload(e);
            }
            returnMessage.setExceptionPayload(exceptionPayload);
        }
        return returnMessage;
    }

    public void handleException(Exception exception) {
        this.service.getExceptionListener().exceptionThrown(exception);
    }

    public String toString() {
        return "proxy for: " + this.service.toString();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    protected ReplyToHandler getReplyToHandler(MuleMessage message, ImmutableEndpoint endpoint) {
        Object replyTo = message.getReplyTo();
        ReplyToHandler replyToHandler = null;
        if (replyTo != null) {
            replyToHandler = ((AbstractConnector)endpoint.getConnector()).getReplyToHandler();
            if (endpoint.getResponseTransformers() != null) {
                replyToHandler.setTransformers(endpoint.getResponseTransformers());
            }
        }
        return replyToHandler;
    }

    private void processReplyTo(MuleMessage returnMessage) throws MuleException {
        if (returnMessage != null && returnMessage.getReplyTo() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sending reply to: " + returnMessage.getReplyTo()));
            }
            ImmutableEndpoint endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(returnMessage.getReplyTo().toString());
            returnMessage.removeProperty("MULE_REPLYTO");
            DefaultMuleEvent replyToEvent = new DefaultMuleEvent(returnMessage, endpoint, this.event.getSession(), false);
            this.onEvent(this.queueSession, replyToEvent);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("reply to sent: " + returnMessage.getReplyTo()));
            }
            if (this.stat.isEnabled()) {
                this.stat.incSentReplyToEvent();
            }
        }
    }

    public void run() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MuleProxy: async onEvent for Mule UMO " + this.service.getName()));
        }
        try {
            if (this.event.getEndpoint().isInbound()) {
                String requestor;
                this.event = OptimizedRequestContext.criticalSetEvent(this.event);
                Object replyTo = this.event.getMessage().getReplyTo();
                ReplyToHandler replyToHandler = this.getReplyToHandler(this.event.getMessage(), this.event.getEndpoint());
                long startTime = 0L;
                if (this.stat.isEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                if (this.service.getName().startsWith("_xfireServiceComponent") || this.service.getName().startsWith("_axisServiceComponent")) {
                    this.event.getMessage().setBooleanProperty("MULE_IGNORE_METHOD", true);
                }
                MuleMessage result = this.umo.intercept(null);
                if (this.service.getName().startsWith("_xfireServiceComponent") || this.service.getName().startsWith("_axisServiceComponent")) {
                    result.removeProperty("MULE_IGNORE_METHOD");
                }
                if (this.stat.isEnabled()) {
                    this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                }
                this.event = RequestContext.getEvent();
                if (result != null && !this.event.isStopFurtherProcessing() && this.service.getOutboundRouter().hasEndpoints()) {
                    this.service.getOutboundRouter().route(result, this.event.getSession(), this.event.isSynchronous());
                }
                if (result != null && replyToHandler != null && ((requestor = (String)result.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.service.getName()) || requestor == null)) {
                    replyToHandler.processReplyTo(this.event, result, replyTo);
                }
            } else {
                this.event.getEndpoint().dispatch(this.event);
            }
            if (this.stat.isEnabled()) {
                this.stat.incSentEventASync();
            }
        }
        catch (Exception e) {
            this.event.getSession().setValid(false);
            if (e instanceof MessagingException) {
                this.handleException(e);
            }
            this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.service.getName()), this.event.getMessage(), (Throwable)e));
        }
    }

    public void release() {
    }
}

