/*
 * Decompiled with CFR 0.152.
 */
package org.mule.agent;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.MuleServer;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.AdminNotification;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.message.DefaultExceptionPayload;
import org.mule.model.seda.SedaService;
import org.mule.transport.AbstractConnector;
import org.mule.transport.NullPayload;
import org.mule.util.MapUtils;
import org.mule.util.object.PrototypeObjectFactory;

public class MuleManagerComponent
implements Callable,
Initialisable,
MuleContextAware {
    protected static final Log logger = LogFactory.getLog(MuleManagerComponent.class);
    public static final String MANAGER_COMPONENT_NAME = "_muleManagerComponent";
    public static final String MANAGER_ENDPOINT_NAME = "_muleManagerEndpoint";
    protected WireFormat wireFormat;
    protected String encoding;
    protected int synchronousEventTimeout = 5000;
    protected MuleContext muleContext;

    public void initialise() throws InitialisationException {
        if (this.wireFormat == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("wireFormat"), (Initialisable)this);
        }
    }

    public Object onCall(MuleEventContext context) throws Exception {
        logger.debug((Object)"Message received by MuleManagerComponent");
        ByteArrayInputStream in = new ByteArrayInputStream(context.transformMessageToBytes());
        AdminNotification action = (AdminNotification)this.wireFormat.read(in);
        Object result = 604 == action.getAction() ? this.invokeAction(action, context) : (603 == action.getAction() || 602 == action.getAction() ? this.sendAction(action, context) : (601 == action.getAction() ? this.receiveAction(action, context) : this.handleException(null, new DefaultMuleException(CoreMessages.eventTypeNotRecognised("AdminNotification:" + action.getAction())))));
        return result;
    }

    protected Object invokeAction(AdminNotification action, MuleEventContext context) throws MuleException {
        String destComponent = null;
        MuleMessage result = null;
        String endpoint = action.getResourceIdentifier();
        destComponent = action.getResourceIdentifier().startsWith("mule:") ? endpoint.substring(endpoint.lastIndexOf("/") + 1) : endpoint;
        if (destComponent != null) {
            DefaultMuleSession session = new DefaultMuleSession(MuleServer.getMuleContext().getRegistry().lookupService(destComponent));
            MuleContext muleContext = MuleServer.getMuleContext();
            EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder(RequestContext.getEvent().getEndpoint(), muleContext);
            builder.setTransformers(new LinkedList());
            ImmutableEndpoint ep = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(builder);
            MuleEvent event = new DefaultMuleEvent(action.getMessage(), ep, context.getSession(), context.isSynchronous());
            event = RequestContext.setEvent(event);
            if (context.isSynchronous()) {
                result = session.getService().sendEvent(event);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.wireFormat.write((OutputStream)out, result, this.getEncoding());
                return out.toByteArray();
            }
            session.getService().dispatchEvent(event);
            return null;
        }
        return this.handleException(result, new DefaultMuleException(CoreMessages.couldNotDetermineDestinationComponentFromEndpoint(endpoint)));
    }

    protected Object sendAction(AdminNotification action, MuleEventContext context) throws MuleException {
        MuleMessage result = null;
        ImmutableEndpoint endpoint = null;
        MuleContext muleContext = context.getMuleContext();
        try {
            if (602 == action.getAction()) {
                endpoint = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(action.getResourceIdentifier());
                context.dispatchEvent(action.getMessage(), endpoint);
                return null;
            }
            EndpointFactory endpointFactory = muleContext.getRegistry().lookupEndpointFactory();
            EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(action.getResourceIdentifier());
            endpointBuilder.setRemoteSync(true);
            endpoint = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointBuilder);
            result = context.sendEvent(action.getMessage(), endpoint);
            if (result == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.wireFormat.write((OutputStream)out, result, this.getEncoding());
            return out.toByteArray();
        }
        catch (Exception e) {
            return this.handleException(result, e);
        }
    }

    protected Object receiveAction(AdminNotification action, MuleEventContext context) throws MuleException {
        MuleMessage result = null;
        try {
            ImmutableEndpoint endpoint = context.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(action.getResourceIdentifier());
            long timeout = MapUtils.getLongValue((Map)action.getProperties(), (Object)"MULE_EVENT_TIMEOUT", (long)this.getSynchronousEventTimeout());
            result = endpoint.getConnector().request(action.getResourceIdentifier(), timeout);
            if (result != null) {
                List transformers = ((AbstractConnector)endpoint.getConnector()).getDefaultInboundTransformers();
                if (transformers != null) {
                    result.applyTransformers(transformers);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.wireFormat.write((OutputStream)out, result, this.getEncoding());
                return out.toByteArray();
            }
            return null;
        }
        catch (Exception e) {
            return this.handleException(result, e);
        }
    }

    public static final Service getService(EndpointBuilder endpointBuilder, WireFormat wireFormat, String encoding, int eventTimeout, MuleContext muleContext) throws MuleException {
        try {
            SedaService service = new SedaService();
            service.setName(MANAGER_COMPONENT_NAME);
            service.setModel(muleContext.getRegistry().lookupSystemModel());
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("wireFormat", wireFormat);
            props.put("encoding", encoding);
            props.put("synchronousEventTimeout", new Integer(eventTimeout));
            service.setServiceFactory(new PrototypeObjectFactory(MuleManagerComponent.class, props));
            service.setMuleContext(muleContext);
            endpointBuilder.setName(MANAGER_ENDPOINT_NAME);
            ImmutableEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(endpointBuilder);
            service.getInboundRouter().addEndpoint(endpoint);
            return service;
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, null);
        }
    }

    protected Object handleException(MuleMessage result, Throwable e) {
        logger.error((Object)("Failed to process admin request: " + e.getMessage()), e);
        if (result == null) {
            result = new DefaultMuleMessage((Object)NullPayload.getInstance(), (Map)null);
        }
        result.setExceptionPayload(new DefaultExceptionPayload(e));
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.wireFormat.write((OutputStream)out, result, this.getEncoding());
            return out.toByteArray();
        }
        catch (Exception e1) {
            logger.error((Object)("Failed to format message, using direct string (details at debug level): " + e1.getMessage()));
            logger.debug((Object)e1.toString(), (Throwable)e1);
            return e.getMessage();
        }
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getSynchronousEventTimeout() {
        return this.synchronousEventTimeout;
    }

    public void setSynchronousEventTimeout(int synchronousEventTimeout) {
        this.synchronousEventTimeout = synchronousEventTimeout;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

