/*
 * Decompiled with CFR 0.152.
 */
package org.mule.agent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.AbstractAgent;
import org.mule.RegistryContext;
import org.mule.agent.MuleManagerComponent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.api.transport.Connector;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.lifecycle.AlreadyInitialisedException;
import org.mule.transformer.wire.SerializationWireFormat;
import org.mule.transport.service.TransportFactory;
import org.mule.util.StringUtils;

public class MuleAdminAgent
extends AbstractAgent {
    public static final String DEFAULT_MANAGER_ENDPOINT = "_muleManagerEndpoint";
    public static final String AGENT_NAME = "MuleAdmin";
    protected static final Log logger = LogFactory.getLog(MuleAdminAgent.class);
    private WireFormat wireFormat;
    private String serverUri;

    public MuleAdminAgent() {
        super(AGENT_NAME);
    }

    public String getDescription() {
        return this.getName() + ": accepting connections on " + this.serverUri;
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void initialise() throws InitialisationException {
        if (this.wireFormat == null) {
            this.wireFormat = new SerializationWireFormat();
        }
        try {
            if (StringUtils.isEmpty((String)this.serverUri)) {
                logger.warn((Object)"No serverUriUrl specified, MuleAdminAgent will not start. E.g. use <mule:admin-agent serverUri=\"tcp://example.com:60504\"/> ");
                this.muleContext.getRegistry().unregisterAgent(this.getName());
                return;
            }
            if (this.muleContext.getRegistry().lookupService("_muleManagerComponent") != null) {
                logger.info((Object)"Mule manager service has already been initialised, ignoring server url");
            } else {
                if (this.muleContext.getRegistry().lookupConnector(DEFAULT_MANAGER_ENDPOINT) != null) {
                    throw new AlreadyInitialisedException("Server Components", (Initialisable)this);
                }
                EndpointBuilder endpointBuilder = this.muleContext.getRegistry().lookupEndpointBuilder(this.serverUri);
                if (endpointBuilder == null) {
                    MuleEndpointURI uri = new MuleEndpointURI(this.serverUri);
                    endpointBuilder = new EndpointURIEndpointBuilder(uri, this.muleContext);
                    endpointBuilder.setSynchronous(true);
                    Connector connector = TransportFactory.getOrCreateConnectorByProtocol(uri, this.muleContext);
                    if (this.muleContext.getRegistry().lookupConnector(connector.getName()) == null) {
                        connector.setName(DEFAULT_MANAGER_ENDPOINT);
                        this.muleContext.getRegistry().registerConnector(connector);
                    }
                    endpointBuilder.setConnector(connector);
                }
                logger.info((Object)("Registering Admin listener on: " + this.serverUri));
                Service service = MuleManagerComponent.getService(endpointBuilder, this.wireFormat, RegistryContext.getConfiguration().getDefaultEncoding(), RegistryContext.getConfiguration().getDefaultSynchronousEventTimeout(), this.muleContext);
                this.muleContext.getRegistry().registerService(service);
            }
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public String toString() {
        return "MuleAdminAgent{serverUri='" + this.serverUri + "'" + "}";
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }
}

