/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.properties;

import java.util.HashMap;
import java.util.Map;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.properties.PropertyExtractor;

public class PropertyExtractorManager {
    public static final String DEFAULT_EXTRACTOR_NAME = "header";
    private static String defaultExtractor = "header";
    private static Map extractors = new HashMap(8);

    public static void registerExtractor(PropertyExtractor extractor) {
        if (extractor == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("extractor").getMessage());
        }
        if (extractors.containsKey(extractor.getName())) {
            throw new IllegalArgumentException(CoreMessages.objectAlreadyExists(extractor.getName()).getMessage());
        }
        extractors.put(extractor.getName(), extractor);
    }

    public static PropertyExtractor unregisterExtractor(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals(PropertyExtractorManager.getDefaultExtractor())) {
            PropertyExtractorManager.setDefaultExtractor(DEFAULT_EXTRACTOR_NAME);
        }
        return (PropertyExtractor)extractors.remove(name);
    }

    public static Object processExpression(String expression, Object object) {
        PropertyExtractor extractor;
        int i;
        String extractorName = PropertyExtractorManager.getDefaultExtractor();
        if (expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (expression.startsWith("${")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if ((i = expression.indexOf(":")) > -1) {
            extractorName = expression.substring(0, i);
            expression = expression.substring(i + 1);
        }
        if ((extractor = (PropertyExtractor)extractors.get(extractorName)) == null) {
            throw new IllegalArgumentException(CoreMessages.noExtractorRegisteredWithKey(extractorName).getMessage());
        }
        return extractor.getProperty(expression, object);
    }

    public static String getDefaultExtractor() {
        return defaultExtractor;
    }

    public static void setDefaultExtractor(String defaultExtractor) {
        if (extractors.get(defaultExtractor) == null) {
            throw new IllegalArgumentException(defaultExtractor);
        }
        PropertyExtractorManager.defaultExtractor = defaultExtractor;
    }

    public static synchronized void clear() {
        defaultExtractor = DEFAULT_EXTRACTOR_NAME;
        extractors.clear();
    }
}

