/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.mule.MuleException;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.endpoint.EndpointURIEndpointBuilder;
import org.mule.routing.filters.EqualsFilter;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.transformer.UMOTransformer;

public final class MuleObjectHelper {
    private MuleObjectHelper() {
    }

    public static List getTransformers(String names, String delim) throws MuleException {
        if (null != names) {
            LinkedList<UMOTransformer> transformers = new LinkedList<UMOTransformer>();
            StringTokenizer st = new StringTokenizer(names, delim);
            while (st.hasMoreTokens()) {
                String key = st.nextToken().trim();
                UMOTransformer transformer = RegistryContext.getRegistry().lookupTransformer(key);
                if (transformer == null) {
                    throw new MuleException(CoreMessages.objectNotRegistered("Transformer", key));
                }
                transformers.add(transformer);
            }
            return transformers;
        }
        return TransformerUtils.UNDEFINED;
    }

    public static UMOImmutableEndpoint getEndpointByProtocol(String protocol) throws UMOException {
        Collection endpoints = RegistryContext.getRegistry().getEndpoints();
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            UMOImmutableEndpoint iprovider = (UMOImmutableEndpoint)iterator.next();
            if (!iprovider.getProtocol().equals(protocol)) continue;
            UMOManagementContext managementContext = MuleServer.getManagementContext();
            EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder(iprovider, managementContext);
            return managementContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(builder);
        }
        return null;
    }

    public static UMOImmutableEndpoint getEndpointByEndpointUri(String endpointUri, boolean wildcardMatch) throws UMOException {
        UMOFilter filter = wildcardMatch ? new WildcardFilter(endpointUri) : new EqualsFilter(endpointUri);
        Collection endpoints = RegistryContext.getRegistry().getEndpoints();
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            UMOImmutableEndpoint iprovider = (UMOImmutableEndpoint)iterator.next();
            if (!filter.accept(iprovider.getEndpointURI())) continue;
            UMOManagementContext managementContext = MuleServer.getManagementContext();
            EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder(iprovider, managementContext);
            return managementContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(builder);
        }
        return null;
    }
}

