/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CoreXMLUtils {
    private static final Log logger = LogFactory.getLog((Class)CoreXMLUtils.class);
    public static final String MULE_DEFAULT_NAMESPACE = "http://www.mulesource.org/schema/mule/core";
    public static final String MULE_NAMESPACE_PREFIX = "http://www.mulesource.org/schema/mule/";

    public static String elementToString(Element e) {
        StringBuffer buf = new StringBuffer();
        buf.append(e.getTagName()).append("{");
        for (int i = 0; i < e.getAttributes().getLength(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            Node n = e.getAttributes().item(i);
            buf.append(CoreXMLUtils.attributeName((Attr)n)).append("=").append(n.getNodeValue());
        }
        buf.append("}");
        return buf.toString();
    }

    public static boolean isMuleNamespace(Element element) {
        String ns = element.getNamespaceURI();
        return ns != null && ns.startsWith(MULE_NAMESPACE_PREFIX);
    }

    public static boolean isBeansNamespace(Element element) {
        String ns = element.getNamespaceURI();
        return ns != null && ns.equals("http://www.springframework.org/schema/beans");
    }

    public static boolean isLocalName(Element element, String name) {
        return element.getLocalName().equals(name);
    }

    public static String attributeName(Attr attribute) {
        String name = attribute.getLocalName();
        if (null == name) {
            name = attribute.getName();
        }
        return name;
    }

    public static String getTextChild(Element element) {
        NodeList children = element.getChildNodes();
        String value = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            if (null != value) {
                throw new IllegalStateException("Element " + CoreXMLUtils.elementToString(element) + " has more than one text child.");
            }
            value = child.getNodeValue();
        }
        return value;
    }

    public static String getNameOrId(Element element) {
        String id = element.getAttribute("id");
        String name = element.getAttribute("name");
        if (StringUtils.isBlank((String)id)) {
            if (StringUtils.isBlank((String)name)) {
                return "";
            }
            return name;
        }
        if (!StringUtils.isBlank((String)name) && !name.equals(id)) {
            logger.warn((Object)("Id (" + id + ") and name (" + name + ") differ for " + CoreXMLUtils.elementToString(element)));
        }
        return id;
    }
}

