/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo.routing;

import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.RoutingException;

public class ComponentRoutingException
extends RoutingException {
    private static final long serialVersionUID = -113944443831267318L;
    private transient UMOComponent component;

    public ComponentRoutingException(Message message, UMOMessage umoMessage, UMOImmutableEndpoint endpoint, UMOComponent component) {
        super(ComponentRoutingException.generateMessage(message, endpoint, component), umoMessage, endpoint);
        this.component = component;
    }

    public ComponentRoutingException(Message message, UMOMessage umoMessage, UMOImmutableEndpoint endpoint, UMOComponent component, Throwable cause) {
        super(ComponentRoutingException.generateMessage(message, endpoint, component), umoMessage, endpoint, cause);
        this.component = component;
    }

    public ComponentRoutingException(UMOMessage umoMessage, UMOImmutableEndpoint endpoint, UMOComponent component) {
        super(ComponentRoutingException.generateMessage(null, endpoint, component), umoMessage, endpoint);
        this.component = component;
    }

    public ComponentRoutingException(UMOMessage umoMessage, UMOImmutableEndpoint endpoint, UMOComponent component, Throwable cause) {
        super(ComponentRoutingException.generateMessage(null, endpoint, component), umoMessage, endpoint, cause);
        this.component = component;
    }

    private static Message generateMessage(Message message, UMOImmutableEndpoint endpoint, UMOComponent component) {
        Message m = CoreMessages.routingFailedOnEndpoint(component.getName(), endpoint.getEndpointURI());
        if (message != null) {
            message.setNextMessage(m);
            return message;
        }
        return m;
    }

    public UMOComponent getComponent() {
        return this.component;
    }
}

