/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo.model;

import java.lang.reflect.Method;
import org.mule.config.i18n.CoreMessages;
import org.mule.umo.model.UMOEntryPointResolver;

public class InvocationResult {
    public static final int STATE_INVOKE_NOT_SUPPORTED = 0;
    public static final int STATE_INVOKED_SUCESSFUL = 1;
    public static final int STATE_INVOKED_FAILED = 2;
    private String errorMessage;
    private String methodCalled;
    private Object result;
    private int state;

    public InvocationResult(int state) {
        if (state < 0 || state > 2) {
            throw new IllegalArgumentException("state");
        }
        this.state = state;
    }

    public InvocationResult(Object result, Method method) {
        this.result = result;
        this.state = 1;
        this.methodCalled = method.getName();
    }

    public String getMethodCalled() {
        return this.methodCalled;
    }

    public Object getResult() {
        return this.result;
    }

    public int getState() {
        return this.state;
    }

    public void setErrorMessage(String message) {
        if (this.state == 1) {
            throw new IllegalStateException(CoreMessages.invocationSuccessfulCantSetError().toString());
        }
        this.errorMessage = message;
    }

    public boolean hasError() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorTooManyMatchingMethods(Object component, Class[] argTypes, String methods, UMOEntryPointResolver resolver) {
        this.setErrorMessage(CoreMessages.tooManyAcceptableMethodsOnObjectUsingResolverForTypes(component.getClass().getName(), argTypes, resolver).toString());
    }

    public void setErrorTooManyMatchingMethods(Object component, Class[] argTypes, UMOEntryPointResolver resolver) {
        this.setErrorMessage(CoreMessages.tooManyAcceptableMethodsOnObjectUsingResolverForTypes(component.getClass().getName(), argTypes, resolver).toString());
    }

    public void setErrorNoMatchingMethods(Object component, Class[] args, UMOEntryPointResolver resolver) {
        this.setErrorMessage(CoreMessages.noEntryPointFoundWithArgsUsingResolver(component.getClass().getName(), args, resolver).toString());
    }

    public void setErrorNoMatchingMethodsCalled(Object component, String methods, UMOEntryPointResolver resolver) {
        this.setErrorMessage(CoreMessages.noMatchingMethodsOnObjectCalledUsingResolver(component.getClass().getName(), methods, resolver).toString());
    }
}

