/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.VoidTransformer;
import org.mule.providers.service.TransportFactoryException;
import org.mule.providers.service.TransportServiceDescriptor;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.CollectionUtils;

public class TransformerUtils {
    public static final List UNDEFINED = Collections.unmodifiableList((List)CollectionUtils.singletonList(VoidTransformer.getInstance()));
    private static Log logger = LogFactory.getLog((Class)AbstractTransformer.class);

    public static void initialiseAllTransformers(List transformers) throws InitialisationException {
        if (TransformerUtils.isDefined(transformers)) {
            Iterator transformer = transformers.iterator();
            while (transformer.hasNext()) {
                ((UMOTransformer)transformer.next()).initialise();
            }
        }
    }

    public static String toString(List transformers) {
        StringBuffer buffer = new StringBuffer();
        if (TransformerUtils.isDefined(transformers)) {
            Iterator transformer = transformers.iterator();
            while (transformer.hasNext()) {
                buffer.append(transformer.next().toString());
                if (!transformer.hasNext()) continue;
                buffer.append(" -> ");
            }
        }
        return buffer.toString();
    }

    public static UMOTransformer firstOrNull(List transformers) {
        if (TransformerUtils.isDefined(transformers) && 0 != transformers.size()) {
            return (UMOTransformer)transformers.get(0);
        }
        return null;
    }

    public static boolean isSourceTypeSupportedByFirst(List transformers, Class clazz) {
        UMOTransformer transformer = TransformerUtils.firstOrNull(transformers);
        return null != transformer && transformer.isSourceTypeSupported(clazz);
    }

    public static boolean isUndefined(List transformers) {
        TransformerUtils.discourageNullTransformers(transformers);
        return null == transformers || UNDEFINED == transformers;
    }

    public static void discourageNullTransformers(List transformers) {
        if (null == transformers && logger.isWarnEnabled()) {
            logger.warn((Object)"Null transformer detected - please use UNDEFINED or empty list, as appropriate");
        }
    }

    public static boolean isDefined(List transformers) {
        return !TransformerUtils.isUndefined(transformers);
    }

    protected static List getTransformersFromSource(TransformerSource source) {
        try {
            List transformers = source.getTransformers();
            TransformerUtils.initialiseAllTransformers(transformers);
            return transformers;
        }
        catch (UMOException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            return UNDEFINED;
        }
    }

    public static List getDefaultInboundTransformers(final TransportServiceDescriptor serviceDescriptor) {
        return TransformerUtils.getTransformersFromSource(new TransformerSource(){

            public List getTransformers() throws TransportFactoryException {
                return serviceDescriptor.createInboundTransformers();
            }
        });
    }

    public static List getDefaultResponseTransformers(final TransportServiceDescriptor serviceDescriptor) {
        return TransformerUtils.getTransformersFromSource(new TransformerSource(){

            public List getTransformers() throws TransportFactoryException {
                return serviceDescriptor.createResponseTransformers();
            }
        });
    }

    public static List getDefaultOutboundTransformers(final TransportServiceDescriptor serviceDescriptor) {
        return TransformerUtils.getTransformersFromSource(new TransformerSource(){

            public List getTransformers() throws TransportFactoryException {
                return serviceDescriptor.createOutboundTransformers();
            }
        });
    }

    protected static interface TransformerSource {
        public List getTransformers() throws TransportFactoryException;
    }
}

