/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mule.transformers.AbstractMessageAwareTransformer;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class TransformerCollection
extends AbstractMessageAwareTransformer {
    private List transformers;

    public TransformerCollection(List transformers) {
        if (transformers.size() < 1) {
            throw new IllegalArgumentException("You must set at least one transformer");
        }
        this.transformers = transformers;
    }

    public TransformerCollection(UMOTransformer[] transformers) {
        if (transformers.length < 1) {
            throw new IllegalArgumentException("You must set at least one transformer");
        }
        this.transformers = Arrays.asList(transformers);
    }

    public Object transform(UMOMessage message, String outputEncoding) throws TransformerException {
        UMOMessage result = message;
        Object temp = message;
        UMOTransformer lastTransformer = null;
        Iterator iterator = this.transformers.iterator();
        while (iterator.hasNext()) {
            lastTransformer = (UMOTransformer)iterator.next();
            temp = lastTransformer.transform(temp);
            if (temp instanceof UMOMessage) {
                result = (UMOMessage)temp;
                continue;
            }
            result.setPayload(temp);
        }
        if (lastTransformer != null && lastTransformer.getReturnClass().equals(UMOMessage.class)) {
            return result;
        }
        return result.getPayload();
    }
}

