/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers;

import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.DebugOptions;

public abstract class AbstractMessageAwareTransformer
extends AbstractTransformer {
    public boolean isSourceTypeSupported(Class aClass, boolean exactMatch) {
        return super.isSourceTypeSupported(aClass, exactMatch) || UMOMessage.class.isAssignableFrom(aClass);
    }

    public final Object doTransform(Object src, String encoding) throws TransformerException {
        UMOMessage message;
        if (src instanceof UMOMessage) {
            message = (UMOMessage)src;
        } else if (DebugOptions.isAutoWrapMessageAwareTransform()) {
            message = new MuleMessage(src);
        } else {
            UMOEventContext event = RequestContext.getEventContext();
            if (event == null) {
                throw new TransformerException(CoreMessages.noCurrentEventForTransformer(), this);
            }
            message = event.getMessage();
            if (!message.getPayload().equals(src)) {
                throw new IllegalStateException("Transform payload does not match current EventContext payload");
            }
        }
        return this.transform(message, encoding);
    }

    public abstract Object transform(UMOMessage var1, String var2) throws TransformerException;
}

