/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.model;

import org.mule.config.ConfigurationException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.umo.UMOComponent;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.umo.manager.UMOContainerContext;

public abstract class AbstractContainerContextTestCase
extends AbstractMuleTestCase {
    public void testContainerContext() throws Exception {
        UMOContainerContext container = this.getContainerContext();
        container.initialise();
        AbstractContainerContextTestCase.assertNotNull((Object)container);
        this.doNullTest(container);
        this.doBadKeyTest(container);
        this.doContentTest(container);
    }

    protected void doNullTest(UMOContainerContext container) {
        try {
            container.getComponent(null);
            AbstractContainerContextTestCase.fail((String)"Should throw ObjectNotFoundException for null key");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    protected void doBadKeyTest(UMOContainerContext container) {
        try {
            container.getComponent("abcdefg123456!\u00ef\u00bf\u00bd$%^n");
            AbstractContainerContextTestCase.fail((String)"Should throw ObjectNotFoundException for a key that doesn't exist");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    protected void doContentTest(UMOContainerContext container) throws Exception {
        Object result = container.getComponent(Apple.class);
        AbstractContainerContextTestCase.assertNotNull((String)"Component should exist in container", (Object)result);
    }

    public void testExternalUMOReference() throws Exception {
        this.getAndVerifyExternalReference(AbstractContainerContextTestCase.getTestComponent("fruit Bowl", FruitBowl.class));
    }

    protected void getAndVerifyExternalReference(UMOComponent component) throws Exception {
        this.verifyExternalReference(this.getExternalReference(component));
    }

    protected Object getExternalReference(UMOComponent component) throws Exception {
        UMOContainerContext container = this.getContainerContext();
        AbstractContainerContextTestCase.assertNotNull((Object)container);
        container.initialise();
        component.initialise();
        FruitBowl fruitBowl = (FruitBowl)container.getComponent(this.getFruitBowlComponentName());
        AbstractContainerContextTestCase.fail((String)"Need to figure out whether this test is relevant for Mule 2.0");
        return null;
    }

    protected void verifyExternalReference(Object object) {
        FruitBowl fruitBowl = (FruitBowl)object;
        AbstractContainerContextTestCase.assertNotNull((Object)fruitBowl);
        AbstractContainerContextTestCase.assertTrue((boolean)fruitBowl.hasApple());
        AbstractContainerContextTestCase.assertTrue((boolean)fruitBowl.hasBanana());
    }

    public abstract UMOContainerContext getContainerContext() throws ConfigurationException;

    protected String getFruitBowlComponentName() {
        return FruitBowl.class.getName();
    }
}

