/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRouterCollection;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.InvalidEndpointTypeException;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOResponseRouter;
import org.mule.umo.routing.UMOResponseRouterCollection;
import org.mule.umo.routing.UMORouter;

public class ResponseRouterCollection
extends AbstractRouterCollection
implements UMOResponseRouterCollection {
    private volatile List endpoints = new CopyOnWriteArrayList();
    private volatile int timeout = 10000;
    private volatile boolean failOnTimeout = true;

    public ResponseRouterCollection() {
        super(3);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        Iterator iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            UMOImmutableEndpoint endpoint = (UMOImmutableEndpoint)iterator.next();
            endpoint.initialise();
        }
    }

    public void route(UMOEvent event) throws RoutingException {
        Iterator iterator = this.getRouters().iterator();
        while (iterator.hasNext()) {
            UMOResponseRouter router = (UMOResponseRouter)iterator.next();
            router.process(event);
            if (!this.getStatistics().isEnabled()) continue;
            this.getStatistics().incrementRoutedMessage(event.getEndpoint());
        }
    }

    public UMOMessage getResponse(UMOMessage message) throws RoutingException {
        UMOMessage result = null;
        if (this.routers.size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"There are no routers configured on the response router. Returning the current message");
            }
            result = message;
        } else {
            Iterator iterator = this.getRouters().iterator();
            while (iterator.hasNext()) {
                UMOResponseRouter router = (UMOResponseRouter)iterator.next();
                result = router.getResponse(message);
            }
            if (result == null && this.getStatistics().isEnabled()) {
                this.getStatistics().incrementNoRoutedMessage();
            }
        }
        return result;
    }

    public void addRouter(UMORouter router) {
        ((UMOResponseRouter)router).setTimeout(this.getTimeout());
        ((UMOResponseRouter)router).setFailOnTimeout(this.isFailOnTimeout());
        this.routers.add(router);
    }

    public UMOResponseRouter removeRouter(UMOResponseRouter router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    public void addEndpoint(UMOImmutableEndpoint endpoint) {
        if (endpoint != null) {
            if (!"response".equals(endpoint.getType())) {
                throw new InvalidEndpointTypeException(CoreMessages.responseRouterMustUseResponseEndpoints(this, endpoint));
            }
        } else {
            throw new IllegalArgumentException("endpoint = null");
        }
        this.endpoints.add(endpoint);
    }

    public boolean removeEndpoint(UMOImmutableEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        if (endpoints != null) {
            this.endpoints.clear();
            this.endpoints.addAll(endpoints);
            Iterator it = this.endpoints.iterator();
            while (it.hasNext()) {
                UMOImmutableEndpoint endpoint = (UMOImmutableEndpoint)it.next();
                if ("response".equals(endpoint.getType())) continue;
                throw new InvalidEndpointTypeException(CoreMessages.responseRouterMustUseResponseEndpoints(this, endpoint));
            }
        } else {
            throw new IllegalArgumentException("List of endpoints = null");
        }
    }

    public UMOImmutableEndpoint getEndpoint(String name) {
        Iterator iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            UMOImmutableEndpoint endpointDescriptor = (UMOImmutableEndpoint)iterator.next();
            if (!endpointDescriptor.getName().equals(name)) continue;
            return endpointDescriptor;
        }
        return null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    public boolean hasEndpoints() {
        return !this.getEndpoints().isEmpty();
    }
}

