/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class TransformerRouter
extends AbstractOutboundRouter {
    private UMOTransformer transformer;

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws MessagingException {
        if (this.transformer != null) {
            try {
                Object payload = this.transformer.transform(message.getPayload());
                message = new MuleMessage(payload, message);
            }
            catch (TransformerException e) {
                throw new RoutingException(CoreMessages.transformFailedBeforeFilter(), message, (UMOImmutableEndpoint)this.endpoints.get(0), e);
            }
        }
        return message;
    }

    public boolean isMatch(UMOMessage message) throws MessagingException {
        return true;
    }

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(UMOTransformer transformer) {
        this.transformer = transformer;
    }
}

