/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.List;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutePathNotFoundException;
import org.mule.umo.routing.RoutingException;

public class ExceptionBasedRouter
extends FilteringOutboundRouter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        int endpointsCount = this.endpoints.size();
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == 0) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(endpointsCount);
            }
        }
        UMOMessage result = null;
        UMOImmutableEndpoint endpoint = null;
        boolean success = false;
        List list = this.endpoints;
        synchronized (list) {
            for (int i = 0; i < endpointsCount; ++i) {
                boolean lastEndpoint;
                endpoint = this.getEndpoint(i, message);
                boolean bl = lastEndpoint = i == endpointsCount - 1;
                if (!lastEndpoint) {
                    this.logger.info((Object)("Sync mode will be forced for " + endpoint.getEndpointURI() + ", as there are more endpoints available."));
                }
                if (!lastEndpoint || synchronous) {
                    try {
                        result = this.send(session, message, endpoint);
                        if (this.exceptionPayloadAvailable(result)) continue;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Successful invocation detected, stopping further processing.");
                        }
                        success = true;
                        break;
                    }
                    catch (UMOException e) {
                        this.logger.warn((Object)("Failed to send to endpoint: " + endpoint.getEndpointURI().toString() + ". Error was: " + ExceptionHelper.getRootException(e) + ". Trying next endpoint"));
                        continue;
                    }
                }
                try {
                    this.dispatch(session, message, endpoint);
                    success = true;
                    break;
                }
                catch (UMOException e) {
                    this.logger.info((Object)("Failed to dispatch to endpoint: " + endpoint.getEndpointURI().toString() + ". Error was: " + e.getMessage() + ". Trying next endpoint"));
                }
            }
        }
        if (!success) {
            throw new CouldNotRouteOutboundMessageException(message, endpoint);
        }
        return result;
    }

    protected boolean exceptionPayloadAvailable(UMOMessage message) {
        if (message == null) {
            return false;
        }
        UMOExceptionPayload exceptionPayload = message.getExceptionPayload();
        if (exceptionPayload != null) {
            this.logger.info((Object)("Failure returned, will try next endpoint. Exception payload is: " + exceptionPayload));
            return true;
        }
        return false;
    }
}

