/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.impl.MuleMessage;
import org.mule.registry.RegistrationException;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutingException;

public abstract class AbstractRecipientList
extends FilteringOutboundRouter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConcurrentMap recipientCache = new ConcurrentHashMap();

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        List recipients = this.getRecipients(message);
        ArrayList<Object> results = new ArrayList<Object>();
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationGroupSize() != -1;
            if (correlationSet && this.enableCorrelation == 0) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(recipients.size());
            }
        }
        UMOMessage result = null;
        Iterator iterator = recipients.iterator();
        while (iterator.hasNext()) {
            Object recipient = iterator.next();
            MuleMessage request = new MuleMessage(message.getPayload(), message);
            UMOImmutableEndpoint endpoint = this.getRecipientEndpoint(request, recipient);
            try {
                if (synchronous) {
                    result = this.send(session, request, endpoint);
                    if (result != null) {
                        results.add(result.getPayload());
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("No result was returned for sync call to: " + endpoint.getEndpointURI()));
                    continue;
                }
                this.dispatch(session, request, endpoint);
            }
            catch (UMOException e) {
                throw new CouldNotRouteOutboundMessageException(request, endpoint, (Throwable)e);
            }
        }
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return new MuleMessage(results.get(0), result);
        }
        return new MuleMessage(results, result);
    }

    protected UMOImmutableEndpoint getRecipientEndpoint(UMOMessage message, Object recipient) throws RoutingException {
        UMOImmutableEndpoint endpoint = null;
        try {
            if (recipient instanceof UMOEndpointURI) {
                endpoint = this.getRecipientEndpointFromUri((UMOEndpointURI)recipient);
            } else if (recipient instanceof String) {
                endpoint = this.getRecipientEndpointFromString(message, (String)recipient);
            }
            if (null == endpoint) {
                throw new RegistrationException("Failed to create endpoint for: " + recipient);
            }
            UMOImmutableEndpoint existingEndpoint = (UMOImmutableEndpoint)this.recipientCache.putIfAbsent(recipient, (Object)endpoint);
            if (existingEndpoint != null) {
                endpoint = existingEndpoint;
            }
        }
        catch (UMOException e) {
            throw new RoutingException(message, endpoint, (Throwable)e);
        }
        return endpoint;
    }

    protected UMOImmutableEndpoint getRecipientEndpointFromUri(UMOEndpointURI uri) throws UMOException {
        UMOImmutableEndpoint endpoint = null;
        if (null != this.getManagementContext() && null != this.getManagementContext().getRegistry()) {
            endpoint = this.getManagementContext().getRegistry().lookupEndpointFactory().getEndpoint(uri, "sender");
        }
        if (null != endpoint) {
            MuleServer.getManagementContext().applyLifecycle(endpoint);
        }
        return endpoint;
    }

    protected UMOImmutableEndpoint getRecipientEndpointFromString(UMOMessage message, String recipient) throws UMOException {
        UMOImmutableEndpoint endpoint = (UMOImmutableEndpoint)this.recipientCache.get((Object)recipient);
        if (null == endpoint && null != this.getManagementContext() && null != this.getManagementContext().getRegistry()) {
            endpoint = this.getManagementContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(recipient);
        }
        return endpoint;
    }

    protected abstract List getRecipients(UMOMessage var1);

    public boolean isDynamicEndpoints() {
        return true;
    }
}

