/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.impl.MuleEvent;
import org.mule.impl.RequestContext;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.ComponentRoutingException;
import org.mule.umo.routing.RoutingException;

public class ComponentCatchAllStrategy
extends AbstractCatchAllStrategy {
    public void setEndpoint(UMOImmutableEndpoint endpoint) {
        throw new UnsupportedOperationException("The endpoint cannot be set on this catch all");
    }

    public UMOImmutableEndpoint getEndpoint() {
        return null;
    }

    public synchronized UMOMessage catchMessage(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOEvent event = RequestContext.getEvent();
        this.logger.debug((Object)("Catch all strategy handling event: " + event));
        try {
            this.logger.info((Object)("Event being routed from catch all strategy for endpoint: " + event.getEndpoint()));
            event = new MuleEvent(message, event.getEndpoint(), session.getComponent(), event);
            if (synchronous) {
                this.statistics.incrementRoutedMessage(event.getEndpoint());
                return session.getComponent().sendEvent(event);
            }
            this.statistics.incrementRoutedMessage(event.getEndpoint());
            session.getComponent().dispatchEvent(event);
            return null;
        }
        catch (UMOException e) {
            throw new ComponentRoutingException(event.getMessage(), event.getEndpoint(), session.getComponent(), (Throwable)e);
        }
    }
}

