/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleEvent;
import org.mule.impl.model.AbstractComponent;
import org.mule.providers.ReplyToHandler;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOEndpointFactory;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;

public class DefaultReplyToHandler
implements ReplyToHandler {
    protected static final Log logger = LogFactory.getLog((Class)DefaultReplyToHandler.class);
    private volatile List transformers;
    private final Map endpointCache = new HashMap();

    public DefaultReplyToHandler(List transformers) {
        this.transformers = transformers;
    }

    public void processReplyTo(UMOEvent event, UMOMessage returnMessage, Object replyTo) throws UMOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sending reply to: " + returnMessage.getReplyTo()));
        }
        String replyToEndpoint = replyTo.toString();
        UMOImmutableEndpoint endpoint = this.getEndpoint(event, replyToEndpoint);
        returnMessage.removeProperty("MULE_REPLYTO");
        MuleEvent replyToEvent = new MuleEvent(returnMessage, endpoint, event.getSession(), false);
        try {
            endpoint.dispatch(replyToEvent);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("reply to sent: " + endpoint));
            }
            ((AbstractComponent)event.getComponent()).getStatistics().incSentReplyToEvent();
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToDispatchToReplyto(endpoint), replyToEvent.getMessage(), replyToEvent.getEndpoint(), e);
        }
    }

    protected synchronized UMOImmutableEndpoint getEndpoint(UMOEvent event, String endpointUri) throws UMOException {
        UMOImmutableEndpoint endpoint = (UMOImmutableEndpoint)this.endpointCache.get(endpointUri);
        if (endpoint == null) {
            UMOEndpointFactory endpointFactory = RegistryContext.getRegistry().lookupEndpointFactory();
            UMOEndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(endpointUri);
            if (this.transformers == null) {
                this.transformers = event.getEndpoint().getResponseTransformers();
            }
            if (this.transformers != null) {
                endpointBuilder.setTransformers(this.transformers);
            }
            endpoint = endpointFactory.getOutboundEndpoint(endpointBuilder);
            this.endpointCache.put(endpointUri, endpoint);
        }
        return endpoint;
    }

    public List getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List transformers) {
        this.transformers = transformers;
    }
}

