/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import javax.resource.spi.work.Work;
import org.mule.impl.OptimizedRequestContext;
import org.mule.impl.RequestContext;
import org.mule.impl.internal.notifications.MessageNotification;
import org.mule.impl.internal.notifications.SecurityNotification;
import org.mule.providers.AbstractConnectable;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.routing.UMOResponseRouterCollection;
import org.mule.umo.security.SecurityException;

public abstract class AbstractMessageDispatcher
extends AbstractConnectable
implements UMOMessageDispatcher {
    public AbstractMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
    }

    public final void dispatch(UMOEvent event) throws DispatchException {
        event.setSynchronous(false);
        event.getMessage().setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
        event = OptimizedRequestContext.criticalSetEvent(event);
        UMOImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireNotification(new SecurityNotification(e, 600));
                this.connector.handleException(e);
                return;
            }
            catch (UMOException e) {
                this.disposeAndLogException();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        try {
            UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
            if (this.isDoThreading() && !event.isSynchronous() && tx == null) {
                this.workManager.scheduleWork(new Worker(event), Long.MAX_VALUE, null, this.connector);
            } else {
                this.connectionStrategy.connect(this);
                this.doDispatch(event);
                if (this.connector.isEnableMessageEvents()) {
                    String component = null;
                    if (event.getComponent() != null) {
                        component = event.getComponent().getName();
                    }
                    this.connector.fireNotification(new MessageNotification(event.getMessage(), event.getEndpoint(), component, 802));
                }
            }
        }
        catch (DispatchException e) {
            this.disposeAndLogException();
            throw e;
        }
        catch (Exception e) {
            this.disposeAndLogException();
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    public final UMOMessage send(UMOEvent event) throws DispatchException {
        if (this.isTransactionRollback()) {
            return event.getMessage();
        }
        event.setSynchronous(true);
        event.getMessage().setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().getUri().toString());
        event = OptimizedRequestContext.unsafeSetEvent(event);
        UMOImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireNotification(new SecurityNotification(e, 401));
                this.connector.handleException(e);
                return event.getMessage();
            }
            catch (UMOException e) {
                this.disposeAndLogException();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        try {
            this.connectionStrategy.connect(this);
            UMOMessage result = this.doSend(event);
            if (this.connector.isEnableMessageEvents()) {
                String component = null;
                if (event.getComponent() != null) {
                    component = event.getComponent().getName();
                }
                this.connector.fireNotification(new MessageNotification(event.getMessage(), event.getEndpoint(), component, 803));
            }
            if (result != null && result.getPropertyNames().contains("MULE_REMOTE_SYNC")) {
                result.removeProperty("MULE_REMOTE_SYNC");
            }
            return result;
        }
        catch (DispatchException e) {
            this.disposeAndLogException();
            throw e;
        }
        catch (Exception e) {
            this.disposeAndLogException();
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    protected boolean useRemoteSync(UMOEvent event) {
        boolean remoteSync = false;
        if (event.getEndpoint().getConnector().isRemoteSyncEnabled()) {
            boolean bl = remoteSync = event.getEndpoint().isRemoteSync() || event.getMessage().getBooleanProperty("MULE_REMOTE_SYNC", false);
            if (remoteSync && event.getComponent() != null) {
                UMOResponseRouterCollection responseRouters = event.getComponent().getResponseRouter();
                remoteSync = responseRouters == null || !responseRouters.hasEndpoints();
            }
        }
        if (!remoteSync) {
            event.getMessage().removeProperty("MULE_REMOTE_SYNC");
        }
        return remoteSync;
    }

    protected boolean isTransactionRollback() {
        try {
            UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
            if (tx != null && tx.isRollbackOnly()) {
                return true;
            }
        }
        catch (TransactionException e) {
            this.logger.warn((Object)e.getMessage());
        }
        return false;
    }

    protected abstract void doDispatch(UMOEvent var1) throws Exception;

    protected abstract UMOMessage doSend(UMOEvent var1) throws Exception;

    private class Worker
    implements Work {
        private UMOEvent event;

        public Worker(UMOEvent event) {
            this.event = event;
        }

        public void run() {
            try {
                this.event = RequestContext.setEvent(this.event);
                AbstractMessageDispatcher.this.connectionStrategy.connect(AbstractMessageDispatcher.this);
                AbstractMessageDispatcher.this.doDispatch(this.event);
                if (AbstractMessageDispatcher.this.connector.isEnableMessageEvents()) {
                    String component = null;
                    if (this.event.getComponent() != null) {
                        component = this.event.getComponent().getName();
                    }
                    AbstractMessageDispatcher.this.connector.fireNotification(new MessageNotification(this.event.getMessage(), this.event.getEndpoint(), component, 802));
                }
            }
            catch (Exception e) {
                AbstractMessageDispatcher.this.getConnector().handleException(e);
            }
        }

        public void release() {
        }
    }
}

