/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.beans.ExceptionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.MuleRuntimeException;
import org.mule.RegistryContext;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.AlreadyInitialisedException;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.MuleSessionHandler;
import org.mule.impl.internal.notifications.ConnectionNotification;
import org.mule.impl.internal.notifications.MessageNotification;
import org.mule.impl.internal.notifications.manager.OptimisedNotificationHandler;
import org.mule.impl.internal.notifications.manager.ServerNotificationHandler;
import org.mule.impl.model.streaming.DelegatingInputStream;
import org.mule.providers.ConnectException;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.DefaultReplyToHandler;
import org.mule.providers.FatalConnectException;
import org.mule.providers.KeyedPoolMessageDispatcherFactoryAdapter;
import org.mule.providers.KeyedPoolMessageRequesterFactoryAdapter;
import org.mule.providers.ReplyToHandler;
import org.mule.providers.SingleAttemptConnectionStrategy;
import org.mule.providers.service.TransportServiceDescriptor;
import org.mule.providers.service.TransportServiceException;
import org.mule.registry.ServiceException;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.DisposeException;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.ConnectorException;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnectable;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.provider.UMOMessageDispatcherFactory;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.provider.UMOMessageRequester;
import org.mule.umo.provider.UMOMessageRequesterFactory;
import org.mule.umo.provider.UMOSessionHandler;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.ObjectNameHelper;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.NamedThreadFactory;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractConnector
implements UMOConnector,
ExceptionListener,
UMOConnectable,
WorkListener {
    public static final int DEFAULT_NUM_CONCURRENT_TX_RECEIVERS = 4;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean initialised = new AtomicBoolean(false);
    protected volatile String name;
    protected volatile ExceptionListener exceptionListener;
    protected final AtomicBoolean disposed = new AtomicBoolean(false);
    protected final AtomicBoolean disposing = new AtomicBoolean(false);
    protected volatile UMOMessageDispatcherFactory dispatcherFactory;
    protected volatile UMOMessageRequesterFactory requesterFactory;
    protected final GenericKeyedObjectPool dispatchers = new GenericKeyedObjectPool();
    protected final GenericKeyedObjectPool requesters = new GenericKeyedObjectPool();
    protected final ConcurrentMap receivers = new ConcurrentHashMap();
    private volatile ThreadingProfile dispatcherThreadingProfile = RegistryContext.getConfiguration().getDefaultMessageDispatcherThreadingProfile();
    private volatile ThreadingProfile requesterThreadingProfile = RegistryContext.getConfiguration().getDefaultMessageRequesterThreadingProfile();
    private volatile ThreadingProfile receiverThreadingProfile = RegistryContext.getConfiguration().getDefaultMessageReceiverThreadingProfile();
    protected volatile boolean createMultipleTransactedReceivers = true;
    protected volatile int numberOfConcurrentTransactedReceivers = 4;
    protected volatile ConnectionStrategy connectionStrategy;
    protected final WaitableBoolean connected = new WaitableBoolean(false);
    protected final WaitableBoolean connecting = new WaitableBoolean(false);
    protected final WaitableBoolean startOnConnect = new WaitableBoolean(false);
    private boolean dynamicNotification = false;
    private ServerNotificationHandler cachedNotificationHandler;
    private final List supportedProtocols;
    private final AtomicReference receiverWorkManager = new AtomicReference();
    private final AtomicReference dispatcherWorkManager = new AtomicReference();
    private final AtomicReference requesterWorkManager = new AtomicReference();
    private final AtomicReference scheduler = new AtomicReference();
    protected volatile TransportServiceDescriptor serviceDescriptor;
    protected volatile Properties serviceOverrides;
    protected volatile UMOSessionHandler sessionHandler = new MuleSessionHandler();
    protected UMOManagementContext managementContext;

    public AbstractConnector() {
        this.setDynamicNotification(false);
        this.supportedProtocols = new ArrayList();
        this.supportedProtocols.add(this.getProtocol().toLowerCase());
        this.connectionStrategy = new SingleAttemptConnectionStrategy();
        this.dispatchers.setTestOnBorrow(false);
        this.dispatchers.setTestOnReturn(true);
        this.requesters.setTestOnBorrow(false);
        this.requesters.setTestOnReturn(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("Connector name").toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set UMOConnector name to: " + newName));
        }
        this.name = newName;
    }

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            AlreadyInitialisedException e = new AlreadyInitialisedException("Connector '" + this.getProtocol() + "." + this.getName() + "'", (Initialisable)this);
            throw e;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initialising: " + this));
        }
        this.initFromServiceDescriptor();
        this.doInitialise();
        if (this.exceptionListener == null) {
            this.exceptionListener = new DefaultExceptionStrategy();
            ((DefaultExceptionStrategy)this.exceptionListener).setManagementContext(this.managementContext);
            ((DefaultExceptionStrategy)this.exceptionListener).initialise();
        }
        try {
            this.initWorkManagers();
        }
        catch (UMOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.initialised.set(true);
    }

    public final synchronized void start() throws UMOException {
        this.checkDisposed();
        if (!this.isStarted()) {
            ScheduledExecutorService currentScheduler;
            if (!this.isConnected()) {
                this.startOnConnect.set(true);
                this.connectionStrategy.connect(this);
                return;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Starting: " + this));
            }
            if ((currentScheduler = (ScheduledExecutorService)this.scheduler.get()) == null || currentScheduler.isShutdown()) {
                this.scheduler.set((Object)this.getScheduler());
            }
            this.doStart();
            this.started.set(true);
            if (this.receivers != null) {
                Iterator iterator = this.receivers.values().iterator();
                while (iterator.hasNext()) {
                    UMOMessageReceiver mr = (UMOMessageReceiver)iterator.next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Starting receiver on endpoint: " + mr.getEndpoint().getEndpointURI()));
                    }
                    mr.start();
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Started: " + this));
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public final synchronized void stop() throws UMOException {
        if (this.isDisposed()) {
            return;
        }
        if (this.isStarted()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Stopping: " + this));
            }
            ((ScheduledExecutorService)this.scheduler.get()).shutdown();
            this.doStop();
            this.started.set(false);
            if (this.receivers != null) {
                Iterator iterator = this.receivers.values().iterator();
                while (iterator.hasNext()) {
                    UMOMessageReceiver mr = (UMOMessageReceiver)iterator.next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Stopping receiver on endpoint: " + mr.getEndpoint().getEndpointURI()));
                    }
                    mr.stop();
                }
            }
        }
        if (this.isConnected()) {
            try {
                this.disconnect();
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to disconnect: " + e.getMessage()), (Throwable)e);
            }
        }
        this.scheduler.set(null);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopped: " + this));
        }
    }

    public final synchronized void dispose() {
        this.disposing.set(true);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposing: " + this));
        }
        try {
            this.stop();
        }
        catch (UMOException e) {
            this.logger.warn((Object)("Failed to stop during shutdown: " + e.getMessage()), (Throwable)e);
        }
        this.disposeReceivers();
        this.disposeDispatchers();
        this.disposeRequesters();
        this.disposeWorkManagers();
        this.doDispose();
        this.disposed.set(true);
        this.initialised.set(false);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposed: " + this));
        }
    }

    protected void initWorkManagers() throws UMOException {
        UMOWorkManager newWorkManager;
        if (this.receiverWorkManager.get() == null && this.receiverWorkManager.compareAndSet(null, (Object)(newWorkManager = this.getReceiverThreadingProfile().createWorkManager(this.getName() + ".receiver")))) {
            newWorkManager.start();
        }
        if (this.dispatcherWorkManager.get() == null && this.dispatcherWorkManager.compareAndSet(null, (Object)(newWorkManager = this.getDispatcherThreadingProfile().createWorkManager(this.getName() + ".dispatcher")))) {
            newWorkManager.start();
        }
    }

    protected void disposeWorkManagers() {
        this.logger.debug((Object)"Disposing dispatcher work manager");
        UMOWorkManager workManager = (UMOWorkManager)this.dispatcherWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.dispatcherWorkManager.set(null);
        this.logger.debug((Object)"Disposing receiver work manager");
        workManager = (UMOWorkManager)this.receiverWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.receiverWorkManager.set(null);
    }

    protected void disposeReceivers() {
        if (this.receivers != null) {
            this.logger.debug((Object)"Disposing Receivers");
            Iterator iterator = this.receivers.values().iterator();
            while (iterator.hasNext()) {
                UMOMessageReceiver receiver = (UMOMessageReceiver)iterator.next();
                try {
                    this.destroyReceiver(receiver, receiver.getEndpoint());
                }
                catch (Throwable e) {
                    this.logger.error((Object)("Failed to destroy receiver: " + receiver), e);
                }
            }
            this.receivers.clear();
            this.logger.debug((Object)"Receivers Disposed");
        }
    }

    protected void disposeDispatchers() {
        if (this.dispatchers != null) {
            this.logger.debug((Object)"Disposing Dispatchers");
            try {
                if (this.isDisposing()) {
                    this.dispatchers.close();
                } else {
                    this.dispatchers.clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.debug((Object)"Dispatchers Disposed");
        }
    }

    protected void disposeRequesters() {
        if (this.requesters != null) {
            this.logger.debug((Object)"Disposing Requesters");
            try {
                if (this.isDisposing()) {
                    this.requesters.close();
                } else {
                    this.requesters.clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.debug((Object)"Requesters Disposed");
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public void handleException(Exception exception) {
        if (this.exceptionListener == null) {
            throw new MuleRuntimeException(CoreMessages.exceptionOnConnectorNotExceptionListener(this.getName()), (Throwable)exception);
        }
        this.exceptionListener.exceptionThrown(exception);
    }

    public void exceptionThrown(Exception e) {
        this.handleException(e);
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public UMOMessageDispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public void setDispatcherFactory(UMOMessageDispatcherFactory dispatcherFactory) {
        Object poolFactory = dispatcherFactory instanceof KeyedPoolableObjectFactory ? (KeyedPoolableObjectFactory)dispatcherFactory : new KeyedPoolMessageDispatcherFactoryAdapter(dispatcherFactory);
        this.dispatchers.setFactory(poolFactory);
        this.dispatcherFactory = dispatcherFactory;
    }

    public UMOMessageRequesterFactory getRequesterFactory() {
        return this.requesterFactory;
    }

    public void setRequesterFactory(UMOMessageRequesterFactory requesterFactory) {
        Object poolFactory = requesterFactory instanceof KeyedPoolableObjectFactory ? (KeyedPoolableObjectFactory)requesterFactory : new KeyedPoolMessageRequesterFactoryAdapter(requesterFactory);
        this.requesters.setFactory(poolFactory);
        this.requesterFactory = requesterFactory;
    }

    public int getMaxDispatchersActive() {
        return this.dispatchers.getMaxActive();
    }

    public void setMaxDispatchersActive(int maxActive) {
        this.dispatchers.setMaxActive(maxActive);
        this.dispatchers.setMaxIdle(maxActive);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UMOMessageDispatcher getDispatcher(UMOImmutableEndpoint endpoint) throws UMOException {
        UMOMessageDispatcher uMOMessageDispatcher;
        this.checkDisposed();
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null");
        }
        if (!this.supportsProtocol(endpoint.getConnector().getProtocol())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(this.getProtocol(), endpoint.getEndpointURI().toString()).getMessage());
        }
        UMOMessageDispatcher dispatcher = null;
        try {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowing a dispatcher for endpoint: " + endpoint.getEndpointURI()));
                }
                dispatcher = (UMOMessageDispatcher)this.dispatchers.borrowObject((Object)endpoint);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowed a dispatcher for endpoint: " + endpoint.getEndpointURI() + " = " + dispatcher.toString()));
                }
                uMOMessageDispatcher = dispatcher;
                Object var5_5 = null;
            }
            catch (Exception ex) {
                throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (!this.logger.isDebugEnabled()) throw throwable;
                this.logger.debug((Object)("Borrowed dispatcher: " + ObjectUtils.toString((Object)dispatcher, (String)"null")));
                throw throwable;
            }
            catch (Exception ex2) {
                throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex2);
            }
        }
        try {}
        catch (Exception ex2) {
            throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex2);
        }
        if (!this.logger.isDebugEnabled()) return uMOMessageDispatcher;
        this.logger.debug((Object)("Borrowed dispatcher: " + ObjectUtils.toString((Object)dispatcher, (String)"null")));
        return uMOMessageDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void returnDispatcher(UMOImmutableEndpoint endpoint, UMOMessageDispatcher dispatcher) {
        block10: {
            if (endpoint != null && dispatcher != null) {
                block9: {
                    if (!this.logger.isDebugEnabled()) break block9;
                    this.logger.debug((Object)("Returning dispatcher for endpoint: " + endpoint.getEndpointURI() + " = " + dispatcher.toString()));
                }
                Object var5_3 = null;
                try {
                    this.dispatchers.returnObject((Object)endpoint, (Object)dispatcher);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to dispose dispatcher for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
                }
                break block10;
                {
                    catch (Exception exception) {
                        Object var5_4 = null;
                        try {
                            this.dispatchers.returnObject((Object)endpoint, (Object)dispatcher);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("Failed to dispose dispatcher for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        this.dispatchers.returnObject((Object)endpoint, (Object)dispatcher);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Failed to dispose dispatcher for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
                    }
                    throw throwable;
                }
            }
        }
    }

    public int getMaxRequestersActive() {
        return this.requesters.getMaxActive();
    }

    public void setMaxRequestersActive(int maxActive) {
        this.requesters.setMaxActive(maxActive);
        this.requesters.setMaxIdle(maxActive);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UMOMessageRequester getRequester(UMOImmutableEndpoint endpoint) throws UMOException {
        UMOMessageRequester uMOMessageRequester;
        this.checkDisposed();
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null");
        }
        if (!this.supportsProtocol(endpoint.getConnector().getProtocol())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(this.getProtocol(), endpoint.getEndpointURI().toString()).getMessage());
        }
        UMOMessageRequester requester = null;
        try {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowing a requester for endpoint: " + endpoint.getEndpointURI()));
                }
                requester = (UMOMessageRequester)this.requesters.borrowObject((Object)endpoint);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowed a requester for endpoint: " + endpoint.getEndpointURI() + " = " + requester.toString()));
                }
                uMOMessageRequester = requester;
                Object var5_5 = null;
            }
            catch (Exception ex) {
                throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (!this.logger.isDebugEnabled()) throw throwable;
                this.logger.debug((Object)("Borrowed requester: " + ObjectUtils.toString((Object)requester, (String)"null")));
                throw throwable;
            }
            catch (Exception ex2) {
                throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex2);
            }
        }
        try {}
        catch (Exception ex2) {
            throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex2);
        }
        if (!this.logger.isDebugEnabled()) return uMOMessageRequester;
        this.logger.debug((Object)("Borrowed requester: " + ObjectUtils.toString((Object)requester, (String)"null")));
        return uMOMessageRequester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void returnRequester(UMOImmutableEndpoint endpoint, UMOMessageRequester requester) {
        block10: {
            if (endpoint != null && requester != null) {
                block9: {
                    if (!this.logger.isDebugEnabled()) break block9;
                    this.logger.debug((Object)("Returning requester for endpoint: " + endpoint.getEndpointURI() + " = " + requester.toString()));
                }
                Object var5_3 = null;
                try {
                    this.requesters.returnObject((Object)endpoint, (Object)requester);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to dispose requester for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
                }
                break block10;
                {
                    catch (Exception exception) {
                        Object var5_4 = null;
                        try {
                            this.requesters.returnObject((Object)endpoint, (Object)requester);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("Failed to dispose requester for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        this.requesters.returnObject((Object)endpoint, (Object)requester);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Failed to dispose requester for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void checkDisposed() throws DisposeException {
        if (this.isDisposed()) {
            throw new DisposeException(CoreMessages.cannotUseDisposedConnector(), (Disposable)this);
        }
    }

    public UMOMessageReceiver registerListener(UMOComponent component, UMOImmutableEndpoint endpoint) throws Exception {
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint cannot be null when registering a listener");
        }
        if (component == null) {
            throw new IllegalArgumentException("The component cannot be null when registering a listener");
        }
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new ConnectorException(CoreMessages.endpointIsNullForListener(), this);
        }
        this.logger.info((Object)("Registering listener: " + component.getName() + " on endpointUri: " + endpointUri.toString()));
        UMOMessageReceiver receiver = this.getReceiver(component, endpoint);
        if (receiver != null) {
            throw new ConnectorException(CoreMessages.listenerAlreadyRegistered(endpointUri), this);
        }
        receiver = this.createReceiver(component, endpoint);
        Object receiverKey = this.getReceiverKey(component, endpoint);
        receiver.setReceiverKey(receiverKey.toString());
        receiver.initialise();
        this.receivers.put(receiverKey, (Object)receiver);
        return receiver;
    }

    protected Object getReceiverKey(UMOComponent component, UMOImmutableEndpoint endpoint) {
        return StringUtils.defaultIfEmpty((String)endpoint.getEndpointURI().getFilterAddress(), (String)endpoint.getEndpointURI().getAddress());
    }

    public final void unregisterListener(UMOComponent component, UMOImmutableEndpoint endpoint) throws Exception {
        UMOMessageReceiver receiver;
        if (component == null) {
            throw new IllegalArgumentException("The component must not be null when you unregister a listener");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint must not be null when you unregister a listener");
        }
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new IllegalArgumentException("The endpointUri must not be null when you unregister a listener");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Removing listener on endpointUri: " + endpointUri));
        }
        if (this.receivers != null && !this.receivers.isEmpty() && (receiver = (UMOMessageReceiver)this.receivers.remove(this.getReceiverKey(component, endpoint))) != null) {
            this.destroyReceiver(receiver, endpoint);
            receiver.dispose();
        }
    }

    public ThreadingProfile getDispatcherThreadingProfile() {
        return this.dispatcherThreadingProfile;
    }

    public void setDispatcherThreadingProfile(ThreadingProfile dispatcherThreadingProfile) {
        this.dispatcherThreadingProfile = dispatcherThreadingProfile;
    }

    public ThreadingProfile getRequesterThreadingProfile() {
        return this.requesterThreadingProfile;
    }

    public void setRequesterThreadingProfile(ThreadingProfile requesterThreadingProfile) {
        this.requesterThreadingProfile = requesterThreadingProfile;
    }

    public ThreadingProfile getReceiverThreadingProfile() {
        return this.receiverThreadingProfile;
    }

    public void setReceiverThreadingProfile(ThreadingProfile receiverThreadingProfile) {
        this.receiverThreadingProfile = receiverThreadingProfile;
    }

    public void destroyReceiver(UMOMessageReceiver receiver, UMOImmutableEndpoint endpoint) throws Exception {
        receiver.dispose();
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doDispose();

    protected abstract void doStart() throws UMOException;

    protected abstract void doStop() throws UMOException;

    public List getDefaultInboundTransformers() {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultInboundTransformers(this.serviceDescriptor);
    }

    public List getDefaultResponseTransformers() {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultResponseTransformers(this.serviceDescriptor);
    }

    public List getDefaultOutboundTransformers() {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultOutboundTransformers(this.serviceDescriptor);
    }

    public ReplyToHandler getReplyToHandler() {
        return new DefaultReplyToHandler(this.getDefaultResponseTransformers());
    }

    public void fireNotification(UMOServerNotification notification) {
        this.cachedNotificationHandler.fireNotification(notification);
    }

    public ConnectionStrategy getConnectionStrategy() {
        try {
            return (ConnectionStrategy)BeanUtils.cloneBean((Object)this.connectionStrategy);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToClone("connectionStrategy"), (Throwable)e);
        }
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public boolean isDisposing() {
        return this.disposing.get();
    }

    public boolean isRemoteSyncEnabled() {
        return false;
    }

    public boolean isSyncEnabled(UMOImmutableEndpoint endpoint) {
        return false;
    }

    public UMOMessageReceiver getReceiver(UMOComponent component, UMOImmutableEndpoint endpoint) {
        if (this.receivers != null) {
            Object key = this.getReceiverKey(component, endpoint);
            if (key != null) {
                return (UMOMessageReceiver)this.receivers.get(key);
            }
            throw new RuntimeException("getReceiverKey() returned a null key");
        }
        throw new RuntimeException("Connector has not been initialized.");
    }

    public Map getReceivers() {
        return Collections.unmodifiableMap(this.receivers);
    }

    public UMOMessageReceiver lookupReceiver(String key) {
        if (key != null) {
            return (UMOMessageReceiver)this.receivers.get((Object)key);
        }
        throw new IllegalArgumentException("Receiver key must not be null");
    }

    public UMOMessageReceiver[] getReceivers(String wildcardExpression) {
        WildcardFilter filter = new WildcardFilter(wildcardExpression);
        filter.setCaseSensitive(false);
        ArrayList found = new ArrayList();
        Iterator iterator = this.receivers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = (Map.Entry)iterator.next();
            if (!filter.accept(e.getKey())) continue;
            found.add(e.getValue());
        }
        return (UMOMessageReceiver[])CollectionUtils.toArrayOfComponentType(found, UMOMessageReceiver.class);
    }

    public void connect() throws Exception {
        this.checkDisposed();
        if (this.connected.get()) {
            return;
        }
        try {
            if (this.connecting.get()) {
                this.doConnect();
            }
            if (this.connecting.compareAndSet(false, true)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Connecting: " + this));
                }
                this.connectionStrategy.connect(this);
                this.logger.info((Object)("Connected: " + this.getConnectionDescription()));
                return;
            }
            this.connected.set(true);
            this.connecting.set(false);
            this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 701));
        }
        catch (Exception e) {
            this.connected.set(false);
            this.connecting.set(false);
            this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 702));
            if (e instanceof ConnectException || e instanceof FatalConnectException) {
                throw e;
            }
            throw new ConnectException((Throwable)e, (UMOConnectable)this);
        }
        if (this.startOnConnect.get()) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws Exception {
        this.startOnConnect.set(this.isStarted());
        this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 703));
        this.connected.set(false);
        try {
            this.doDisconnect();
        }
        finally {
            this.stop();
        }
        this.logger.info((Object)("Disconnected: " + this.getConnectionDescription()));
    }

    public String getConnectionDescription() {
        return this.toString();
    }

    public final boolean isConnected() {
        return this.connected.get();
    }

    protected abstract void doConnect() throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected String getConnectEventId() {
        return this.getName();
    }

    public boolean isCreateMultipleTransactedReceivers() {
        return this.createMultipleTransactedReceivers;
    }

    public void setCreateMultipleTransactedReceivers(boolean createMultipleTransactedReceivers) {
        this.createMultipleTransactedReceivers = createMultipleTransactedReceivers;
    }

    public int getNumberOfConcurrentTransactedReceivers() {
        return this.numberOfConcurrentTransactedReceivers;
    }

    public void setNumberOfConcurrentTransactedReceivers(int count) {
        this.numberOfConcurrentTransactedReceivers = count;
    }

    public void setDynamicNotification(boolean dynamic) {
        this.dynamicNotification = dynamic;
    }

    protected void updateCachedNotificationHandler() {
        if (null != this.managementContext) {
            this.cachedNotificationHandler = this.dynamicNotification ? this.managementContext.getNotificationManager() : new OptimisedNotificationHandler(this.managementContext.getNotificationManager(), MessageNotification.class);
        }
    }

    public boolean isEnableMessageEvents() {
        return this.cachedNotificationHandler.isNotificationEnabled(MessageNotification.class);
    }

    public void registerSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.registerSupportedProtocolWithoutPrefix(protocol);
        } else {
            this.supportedProtocols.add(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    protected void registerSupportedProtocolWithoutPrefix(String protocol) {
        this.supportedProtocols.add(protocol.toLowerCase());
    }

    public void unregisterSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.supportedProtocols.remove(protocol);
        } else {
            this.supportedProtocols.remove(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    public boolean supportsProtocol(String protocol) {
        return this.supportedProtocols.contains(protocol.toLowerCase());
    }

    public List getSupportedProtocols() {
        return Collections.unmodifiableList(this.supportedProtocols);
    }

    public void setSupportedProtocols(List supportedProtocols) {
        Iterator iterator = supportedProtocols.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            this.registerSupportedProtocol(s);
        }
    }

    protected UMOWorkManager getReceiverWorkManager(String receiverName) throws UMOException {
        return (UMOWorkManager)this.receiverWorkManager.get();
    }

    protected UMOWorkManager getDispatcherWorkManager() throws UMOException {
        return (UMOWorkManager)this.dispatcherWorkManager.get();
    }

    protected UMOWorkManager getRequesterWorkManager() throws UMOException {
        return (UMOWorkManager)this.requesterWorkManager.get();
    }

    public ScheduledExecutorService getScheduler() {
        if (this.scheduler.get() == null) {
            NamedThreadFactory threadFactory = new NamedThreadFactory(this.getName() + ".scheduler");
            ScheduledThreadPoolExecutor newExecutor = new ScheduledThreadPoolExecutor(4, (ThreadFactory)threadFactory);
            newExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            newExecutor.setKeepAliveTime(this.getReceiverThreadingProfile().getThreadTTL(), TimeUnit.MILLISECONDS);
            newExecutor.allowCoreThreadTimeOut(true);
            if (!this.scheduler.compareAndSet(null, (Object)newExecutor)) {
                newExecutor.shutdown();
            }
        }
        return (ScheduledExecutorService)this.scheduler.get();
    }

    public UMOSessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public void setSessionHandler(UMOSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null) {
            return;
        }
        Throwable e = event.getException();
        if (e == null) {
            return;
        }
        if (e.getCause() != null) {
            e = e.getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (!(e instanceof Exception)) {
            throw new MuleRuntimeException(CoreMessages.connectorCausedError(this.getName()), e);
        }
        this.handleException((Exception)e);
    }

    public void dispatch(UMOImmutableEndpoint endpoint, UMOEvent event) throws DispatchException {
        UMOMessageDispatcher dispatcher = null;
        try {
            dispatcher = this.getDispatcher(endpoint);
            dispatcher.dispatch(event);
        }
        catch (DispatchException dex) {
            throw dex;
        }
        catch (UMOException ex) {
            throw new DispatchException(event.getMessage(), endpoint, (Throwable)ex);
        }
        finally {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    protected void setupDispatchReturn(final UMOImmutableEndpoint endpoint, final UMOMessageDispatcher dispatcher, UMOMessage result) {
        if (result != null && result.getPayload() instanceof InputStream) {
            DelegatingInputStream is = new DelegatingInputStream((InputStream)result.getPayload()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        AbstractConnector.this.returnDispatcher(endpoint, dispatcher);
                    }
                }
            };
            result.setPayload(is);
        } else {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    public UMOMessage request(String uri, long timeout) throws Exception {
        return this.request(this.getManagementContext().getRegistry().lookupEndpointFactory().getInboundEndpoint(uri), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage request(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        UMOMessageRequester requester = null;
        UMOMessage result = null;
        try {
            requester = this.getRequester(endpoint);
            UMOMessage uMOMessage = result = requester.request(timeout);
            this.setupRequestReturn(endpoint, requester, result);
            return uMOMessage;
        }
        catch (Throwable throwable) {
            this.setupRequestReturn(endpoint, requester, result);
            throw throwable;
        }
    }

    protected void setupRequestReturn(final UMOImmutableEndpoint endpoint, final UMOMessageRequester requester, UMOMessage result) {
        if (result != null && result.getPayload() instanceof InputStream) {
            DelegatingInputStream is = new DelegatingInputStream((InputStream)result.getPayload()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        AbstractConnector.this.returnRequester(endpoint, requester);
                    }
                }
            };
            result.setPayload(is);
        } else {
            this.returnRequester(endpoint, requester);
        }
    }

    public UMOMessage send(UMOImmutableEndpoint endpoint, UMOEvent event) throws DispatchException {
        UMOMessageDispatcher dispatcher = null;
        try {
            dispatcher = this.getDispatcher(endpoint);
            UMOMessage uMOMessage = dispatcher.send(event);
            return uMOMessage;
        }
        catch (DispatchException dex) {
            throw dex;
        }
        catch (UMOException ex) {
            throw new DispatchException(event.getMessage(), endpoint, (Throwable)ex);
        }
        finally {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    public void initialiseFromUrl(UMOEndpointURI endpointUri) throws InitialisationException {
        String host;
        if (!this.supportsProtocol(endpointUri.getFullScheme())) {
            throw new InitialisationException(CoreMessages.schemeNotCompatibleWithConnector(endpointUri.getFullScheme(), this.getClass()), (Initialisable)this);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)endpointUri.getParams());
        if (endpointUri.getUserInfo() != null) {
            props.setProperty("username", endpointUri.getUser());
            String passwd = endpointUri.getPassword();
            if (passwd != null) {
                props.setProperty("password", passwd);
            }
        }
        if ((host = endpointUri.getHost()) != null) {
            props.setProperty("hostname", host);
            props.setProperty("host", host);
        }
        if (endpointUri.getPort() > -1) {
            props.setProperty("port", String.valueOf(endpointUri.getPort()));
        }
        BeanUtils.populateWithoutFail(this, props, true);
        this.setName(ObjectNameHelper.getConnectorName(this));
    }

    protected synchronized void initFromServiceDescriptor() throws InitialisationException {
        try {
            UMOMessageRequesterFactory rf;
            UMOMessageDispatcherFactory df;
            this.serviceDescriptor = (TransportServiceDescriptor)RegistryContext.getRegistry().lookupServiceDescriptor("transport", this.getProtocol().toLowerCase(), this.serviceOverrides);
            if (this.serviceDescriptor == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(this.getProtocol()));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading DispatcherFactory for connector: " + this.getName() + " (" + this.getClass().getName() + ")"));
            }
            if ((df = this.serviceDescriptor.createDispatcherFactory()) != null) {
                this.setDispatcherFactory(df);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transport '" + this.getProtocol() + "' will not support outbound endpoints: "));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading RequesterFactory for connector: " + this.getName() + " (" + this.getClass().getName() + ")"));
            }
            if ((rf = this.serviceDescriptor.createRequesterFactory()) != null) {
                this.setRequesterFactory(rf);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transport '" + this.getProtocol() + "' will not support requests: "));
            }
            this.sessionHandler = this.serviceDescriptor.createSessionHandler();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected TransportServiceDescriptor getServiceDescriptor() {
        if (this.serviceDescriptor == null) {
            throw new IllegalStateException("This connector has not yet been initialised: " + this.name);
        }
        return this.serviceDescriptor;
    }

    protected UMOMessageReceiver createReceiver(UMOComponent component, UMOImmutableEndpoint endpoint) throws Exception {
        return this.getServiceDescriptor().createMessageReceiver(this, component, endpoint);
    }

    public UMOMessageAdapter getMessageAdapter(Object message) throws MessagingException {
        try {
            return this.serviceDescriptor.createMessageAdapter(message);
        }
        catch (TransportServiceException e) {
            throw new MessagingException(CoreMessages.failedToCreate("Message Adapter"), message, (Throwable)e);
        }
    }

    public Map getServiceOverrides() {
        return this.serviceOverrides;
    }

    public void setServiceOverrides(Map serviceOverrides) {
        this.serviceOverrides = new Properties();
        this.serviceOverrides.putAll((Map<?, ?>)serviceOverrides);
    }

    public OutputStream getOutputStream(UMOImmutableEndpoint endpoint, UMOMessage message) throws UMOException {
        throw new UnsupportedOperationException(CoreMessages.streamingNotSupported(this.getProtocol()).toString());
    }

    public UMOManagementContext getManagementContext() {
        return this.managementContext;
    }

    public void setManagementContext(UMOManagementContext context) {
        this.managementContext = context;
        this.updateCachedNotificationHandler();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(120);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", started=").append(this.started);
        sb.append(", initialised=").append(this.initialised);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", disposed=").append(this.disposed);
        sb.append(", numberOfConcurrentTransactedReceivers=").append(this.numberOfConcurrentTransactedReceivers);
        sb.append(", createMultipleTransactedReceivers=").append(this.createMultipleTransactedReceivers);
        sb.append(", connected=").append(this.connected);
        sb.append(", supportedProtocols=").append(this.supportedProtocols);
        sb.append(", serviceOverrides=").append(this.serviceOverrides);
        sb.append('}');
        return sb.toString();
    }
}

