/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.FatalConnectException;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.UMOConnectable;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;

public abstract class AbstractConnectionStrategy
implements ConnectionStrategy {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private volatile boolean doThreading = false;
    private UMOWorkManager workManager;
    private final Object reconnectLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(final UMOConnectable connectable) throws FatalConnectException {
        Object object;
        if (this.doThreading) {
            try {
                UMOWorkManager wm = this.getWorkManager();
                if (wm == null) {
                    throw new FatalConnectException(MessageFactory.createStaticMessage("No WorkManager is available"), connectable);
                }
                wm.scheduleWork(new Work(){

                    public void release() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block9: {
                            try {
                                Object object = AbstractConnectionStrategy.this.reconnectLock;
                                synchronized (object) {
                                    AbstractConnectionStrategy.this.doConnect(connectable);
                                }
                            }
                            catch (FatalConnectException e) {
                                Object object = AbstractConnectionStrategy.this.reconnectLock;
                                synchronized (object) {
                                    AbstractConnectionStrategy.this.resetState();
                                }
                                if (connectable instanceof UMOConnector) {
                                    ((UMOConnector)((Object)connectable)).handleException(e);
                                }
                                if (!(connectable instanceof AbstractMessageReceiver)) break block9;
                                ((AbstractMessageReceiver)connectable).handleException(e);
                            }
                        }
                    }
                });
            }
            catch (WorkException e) {
                Object object2 = this.reconnectLock;
                synchronized (object2) {
                    this.resetState();
                }
                throw new FatalConnectException((Throwable)e, connectable);
            }
        }
        try {
            object = this.reconnectLock;
            synchronized (object) {
                this.doConnect(connectable);
            }
        }
        finally {
            object = this.reconnectLock;
            synchronized (object) {
                this.resetState();
            }
        }
    }

    public boolean isDoThreading() {
        return this.doThreading;
    }

    public void setDoThreading(boolean doThreading) {
        this.doThreading = doThreading;
    }

    public UMOWorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(UMOWorkManager workManager) {
        this.workManager = workManager;
    }

    protected abstract void doConnect(UMOConnectable var1) throws FatalConnectException;

    public abstract void resetState();

    protected String getDescription(UMOConnectable connectable) {
        if (connectable instanceof UMOMessageReceiver) {
            return ((UMOMessageReceiver)connectable).getEndpointURI().toString();
        }
        return connectable.toString();
    }
}

