/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.work;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.text.MessageFormat;
import java.util.List;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ThreadingProfile;
import org.mule.impl.work.ScheduleWorkExecutor;
import org.mule.impl.work.StartWorkExecutor;
import org.mule.impl.work.SyncWorkExecutor;
import org.mule.impl.work.WorkExecutor;
import org.mule.impl.work.WorkerContext;
import org.mule.umo.UMOException;
import org.mule.umo.manager.UMOWorkManager;

public class MuleWorkManager
implements UMOWorkManager {
    protected static final Log logger = LogFactory.getLog((Class)MuleWorkManager.class);
    private static final long SHUTDOWN_TIMEOUT = 5000L;
    private final ThreadingProfile threadingProfile;
    private volatile ExecutorService workExecutorService;
    private final String name;
    private final WorkExecutor scheduleWorkExecutor = new ScheduleWorkExecutor();
    private final WorkExecutor startWorkExecutor = new StartWorkExecutor();
    private final WorkExecutor syncWorkExecutor = new SyncWorkExecutor();

    public MuleWorkManager(ThreadingProfile profile, String name) {
        if (name == null) {
            name = "WorkManager#" + this.hashCode();
        }
        this.threadingProfile = profile;
        this.name = name;
    }

    public synchronized void start() throws UMOException {
        if (this.workExecutorService == null) {
            this.workExecutorService = this.threadingProfile.createPool(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (this.workExecutorService != null) {
            try {
                List outstanding = this.workExecutorService.shutdownNow();
                if (!this.workExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS) && logger.isWarnEnabled()) {
                    logger.warn((Object)MessageFormat.format("Pool {0} did not terminate in time; {1} work items were cancelled.", this.name, outstanding.isEmpty() ? "No" : Integer.toString(outstanding.size())));
                }
            }
            catch (InterruptedException ie) {
                this.workExecutorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
            finally {
                this.workExecutorService = null;
            }
        }
    }

    public XATerminator getXATerminator() {
        return null;
    }

    public void doWork(Work work) throws WorkException {
        this.executeWork(new WorkerContext(work), this.syncWorkExecutor);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.syncWorkExecutor);
    }

    public long startWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public void scheduleWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor);
    }

    public void execute(Runnable work) {
        if (this.workExecutorService == null) {
            throw new IllegalStateException("This MuleWorkManager '" + this.name + "' was never started");
        }
        if (this.workExecutorService.isShutdown()) {
            throw new IllegalStateException("This MuleWorkManager '" + this.name + "' is stopped");
        }
        this.workExecutorService.execute(work);
    }

    private void executeWork(WorkerContext work, WorkExecutor workExecutor) throws WorkException {
        if (this.workExecutorService == null || this.workExecutorService.isShutdown()) {
            throw new IllegalStateException("This MuleWorkManager '" + this.name + "' is stopped");
        }
        try {
            work.workAccepted(this);
            workExecutor.doExecute(work, (Executor)this.workExecutorService);
            WorkException exception = work.getWorkException();
            if (null != exception) {
                throw exception;
            }
        }
        catch (InterruptedException e) {
            WorkCompletedException wcj = new WorkCompletedException("The execution has been interrupted for WorkManager: " + this.name, (Throwable)e);
            wcj.setErrorCode("-1");
            throw wcj;
        }
    }
}

