/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.seda.optimised;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.model.MuleProxy;
import org.mule.management.stats.ComponentStatistics;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Startable;
import org.mule.umo.lifecycle.Stoppable;
import org.mule.umo.model.ModelException;
import org.mule.util.queue.QueueSession;

public class OptimisedMuleProxy
implements MuleProxy {
    private static Log logger = LogFactory.getLog((Class)OptimisedMuleProxy.class);
    private UMOEvent event;
    private UMOComponent component;
    private boolean suspended = true;
    private ComponentStatistics stat = null;
    private Callable pojoService;
    private boolean started = false;
    private boolean disposed = false;

    public OptimisedMuleProxy(Callable pojoService, UMOComponent component) throws UMOException {
        this.component = component;
        this.pojoService = pojoService;
    }

    public void start() throws UMOException {
        this.checkDisposed();
        if (!this.started && this.pojoService instanceof Startable) {
            try {
                ((Startable)((Object)this.pojoService)).start();
                this.started = true;
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStart("Component '" + this.component.getName() + "'"), (Throwable)e);
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() throws UMOException {
        this.checkDisposed();
        if (this.started && this.pojoService instanceof Stoppable) {
            this.started = false;
            try {
                ((Stoppable)((Object)this.pojoService)).stop();
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStop("Component '" + this.component.getName() + "'"), (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.checkDisposed();
        if (this.pojoService instanceof Disposable) {
            ((Disposable)((Object)this.pojoService)).dispose();
            this.disposed = true;
        }
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Components Disposed Of");
        }
    }

    public void onEvent(QueueSession session, UMOEvent event) {
        this.event = event;
    }

    public ComponentStatistics getStatistics() {
        return this.stat;
    }

    public void setStatistics(ComponentStatistics stat) {
        this.stat = stat;
    }

    public Object onCall(UMOEvent event) throws UMOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MuleProxy: sync call for Mule UMO " + this.component.getName()));
        }
        UMOMessage returnMessage = null;
        try {
            if (event.getEndpoint().canRequest()) {
                long startTime = 0L;
                if (this.stat.isEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                returnMessage = this.invokeUmo(RequestContext.getEventContext());
                if (this.stat.isEnabled()) {
                    this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                }
                if ((event = RequestContext.getEvent()).isStopFurtherProcessing()) {
                    logger.debug((Object)"Event stop further processing has been set, no outbound routing will be performed.");
                }
                if (returnMessage != null && !event.isStopFurtherProcessing()) {
                    if (this.component.getOutboundRouter().hasEndpoints()) {
                        UMOMessage outboundReturnMessage = this.component.getOutboundRouter().route(returnMessage, event.getSession(), event.isSynchronous());
                        if (outboundReturnMessage != null) {
                            returnMessage = outboundReturnMessage;
                        }
                    } else {
                        logger.debug((Object)("Outbound router on component '" + this.component.getName() + "' doesn't have any endpoints configured."));
                    }
                }
            } else {
                returnMessage = event.getSession().sendEvent(event);
            }
            if (this.stat.isEnabled()) {
                this.stat.incSentEventSync();
            }
        }
        catch (Exception e) {
            event.getSession().setValid(false);
            if (e instanceof UMOException) {
                this.handleException(e);
            }
            this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.component.getName()), event.getMessage(), (Throwable)e));
        }
        return returnMessage;
    }

    protected UMOMessage invokeUmo(UMOEventContext context) throws Exception {
        Object result = this.pojoService.onCall(RequestContext.getEventContext());
        if (result != null) {
            if (result instanceof UMOMessage) {
                return (UMOMessage)result;
            }
            return new MuleMessage(result, context.getMessage());
        }
        return null;
    }

    public void handleException(Exception exception) {
        this.component.getExceptionListener().exceptionThrown(exception);
    }

    public String toString() {
        return "optimised proxy for: " + this.component.toString();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MuleProxy: async onEvent for Mule UMO " + this.component.getName()));
        }
        try {
            block12: {
                try {
                    if (this.event.getEndpoint().canRequest()) {
                        this.event = RequestContext.setEvent(this.event);
                        long startTime = 0L;
                        if (this.stat.isEnabled()) {
                            startTime = System.currentTimeMillis();
                        }
                        UMOMessage result = this.invokeUmo(RequestContext.getEventContext());
                        if (this.stat.isEnabled()) {
                            this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                        }
                        this.event = RequestContext.getEvent();
                        if (result != null && !this.event.isStopFurtherProcessing()) {
                            this.component.getOutboundRouter().route(result, this.event.getSession(), this.event.isSynchronous());
                        }
                    } else {
                        this.event.getEndpoint().dispatch(this.event);
                    }
                    if (!this.stat.isEnabled()) break block12;
                    this.stat.incSentEventASync();
                }
                catch (Exception e) {
                    this.event.getSession().setValid(false);
                    if (e instanceof UMOException) {
                        this.handleException(e);
                    } else {
                        this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.component.getName()), this.event.getMessage(), (Throwable)e));
                    }
                    Object var5_5 = null;
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    public void release() {
    }

    public Callable getPojoService() {
        return this.pojoService;
    }
}

