/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.seda;

import java.util.NoSuchElementException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.mule.MuleRuntimeException;
import org.mule.RegistryContext;
import org.mule.config.MuleConfiguration;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.FailedToQueueEventException;
import org.mule.impl.MuleEvent;
import org.mule.impl.model.AbstractComponent;
import org.mule.impl.model.MuleProxy;
import org.mule.impl.model.seda.SedaModel;
import org.mule.management.stats.ComponentStatistics;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.lifecycle.Startable;
import org.mule.umo.lifecycle.Stoppable;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class SedaComponent
extends AbstractComponent
implements Work,
WorkListener {
    private static final long serialVersionUID = 7711976708670893015L;
    protected UMOWorkManager workManager;
    protected Integer queueTimeout;
    protected ThreadingProfile threadingProfile;
    protected QueueProfile queueProfile;

    public synchronized void doInitialise() throws InitialisationException {
        MuleConfiguration config = RegistryContext.getConfiguration();
        if (this.threadingProfile == null) {
            this.threadingProfile = config.getDefaultComponentThreadingProfile();
        }
        this.workManager = this.threadingProfile.createWorkManager(this.getName());
        if (this.queueProfile == null) {
            this.queueProfile = ((SedaModel)this.model).getQueueProfile();
        }
        if (this.queueTimeout == null) {
            this.setQueueTimeout(new Integer(((SedaModel)this.model).getQueueTimeout()));
        }
        try {
            if (this.name == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage("Component has no name to identify it"), (Initialisable)this);
            }
            this.queueProfile.configureQueue(this.name, this.managementContext.getQueueManager());
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InitialisationException(CoreMessages.objectFailedToInitialise("Component Queue"), e, this);
        }
    }

    public void doForceStop() throws UMOException {
        this.doStop();
    }

    public void doStop() throws UMOException {
        this.workManager.dispose();
        if (this.serviceFactory instanceof Stoppable) {
            ((Stoppable)((Object)this.serviceFactory)).stop();
        }
    }

    public void doStart() throws UMOException {
        try {
            if (this.serviceFactory instanceof Startable) {
                ((Startable)((Object)this.serviceFactory)).start();
            }
            this.workManager.start();
            this.workManager.scheduleWork(this, Long.MAX_VALUE, null, this);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart("Component: " + this.name), e, this);
        }
    }

    protected void doDispose() {
        if (this.workManager != null) {
            this.workManager.dispose();
        }
        this.serviceFactory.dispose();
    }

    protected void doDispatch(UMOEvent event) throws UMOException {
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Component: " + this.name + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        try {
            this.enqueue(event);
            if (this.stats.isEnabled()) {
                this.stats.incQueuedEvent();
            }
        }
        catch (Exception e) {
            FailedToQueueEventException e1 = new FailedToQueueEventException(CoreMessages.interruptedQueuingEventFor(this.getName()), event.getMessage(), this, e);
            this.handleException(e1);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Event added to queue for: " + this.name));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UMOMessage doSend(UMOEvent event) throws UMOException {
        UMOMessage result = null;
        Object pojoService = null;
        MuleProxy proxy = null;
        try {
            try {
                pojoService = this.getOrCreateService();
                proxy = this.createComponentProxy(pojoService);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(this + " : got proxy for " + event.getId() + " = " + proxy));
                }
                result = (UMOMessage)proxy.onCall(event);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ComponentException(event.getMessage(), this, (Throwable)e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                this.serviceFactory.release(pojoService);
                throw throwable;
            }
            catch (Exception e) {
                throw new ComponentException(event.getMessage(), this, (Throwable)e);
            }
        }
        try {}
        catch (Exception e) {
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
        this.serviceFactory.release(pojoService);
        return result;
    }

    public int getQueueSize() {
        QueueSession session = this.managementContext.getQueueManager().getQueueSession();
        Queue queue = session.getQueue(this.name);
        if (queue == null) {
            this.logger.warn((Object)new InitialisationException(MessageFactory.createStaticMessage("Queue " + this.name + " not created for component " + this.name), (Initialisable)this));
            return -1;
        }
        return queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MuleEvent event = null;
        Object pojoService = null;
        MuleProxy proxy = null;
        QueueSession queueSession = this.managementContext.getQueueManager().getQueueSession();
        while (!this.stopped.get()) {
            try {
                this.paused.whenFalse(null);
                if (this.stopping.get() && (queueSession == null || this.getQueueSize() <= 0)) {
                    this.stopping.set(false);
                    break;
                }
                event = (MuleEvent)this.dequeue();
                if (event == null) continue;
                if (this.stats.isEnabled()) {
                    this.stats.decQueuedEvent();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Component: " + this.name + " dequeued event on: " + event.getEndpoint().getEndpointURI()));
                }
                pojoService = this.getOrCreateService();
                proxy = this.createComponentProxy(pojoService);
                proxy.onEvent(queueSession, event);
                this.workManager.scheduleWork(proxy, Long.MAX_VALUE, null, this);
            }
            catch (Exception e) {
                if (this.isStopped() || this.isStopping()) break;
                try {
                    if (this.serviceFactory != null) {
                        this.serviceFactory.release(pojoService);
                    }
                }
                catch (Exception e2) {
                    this.logger.warn((Object)e2);
                }
                if (e instanceof InterruptedException) {
                    this.stopping.set(false);
                    break;
                }
                if (e instanceof NoSuchElementException) {
                    this.handleException(new ComponentException(CoreMessages.proxyPoolTimedOut(), event == null ? null : event.getMessage(), this, e));
                    continue;
                }
                if (e instanceof UMOException) {
                    this.handleException(e);
                    continue;
                }
                if (e instanceof WorkException) {
                    this.handleException(new ComponentException(CoreMessages.eventProcessingFailedFor(this.name), event == null ? null : event.getMessage(), this, e));
                    continue;
                }
                this.handleException(new ComponentException(CoreMessages.failedToGetPooledObject(), event == null ? null : event.getMessage(), this, e));
            }
            finally {
                this.stopping.set(false);
            }
        }
    }

    public void release() {
        this.stopping.set(false);
    }

    protected void enqueue(UMOEvent event) throws Exception {
        QueueSession session = this.managementContext.getQueueManager().getQueueSession();
        Queue queue = session.getQueue(this.name);
        if (queue == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Queue " + this.name + " not created for component " + this.name), (Initialisable)this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Component " + this.name + " putting event on queue " + this.name + ": " + event));
        }
        queue.put(event);
    }

    protected UMOEvent dequeue() throws Exception {
        QueueSession session = this.managementContext.getQueueManager().getQueueSession();
        Queue queue = session.getQueue(this.name);
        if (queue == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Queue " + this.name + " not created for component " + this.name), (Initialisable)this);
        }
        if (this.logger.isDebugEnabled()) {
            // empty if block
        }
        if (this.getQueueTimeout() == null) {
            throw new InitialisationException(CoreMessages.noComponentQueueTimeoutSet(this), (Initialisable)this);
        }
        return (UMOEvent)queue.poll(this.getQueueTimeout().intValue());
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null || event.getException() == null) {
            return;
        }
        Object e = event.getException();
        if (event.getException().getCause() != null) {
            e = event.getException().getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (!(e instanceof Exception)) {
            throw new MuleRuntimeException(CoreMessages.componentCausedErrorIs(this.getName()), (Throwable)e);
        }
        this.handleException((Exception)e);
    }

    protected ComponentStatistics createStatistics() {
        return new ComponentStatistics(this.getName(), this.threadingProfile.getMaxThreadsActive());
    }

    public Object getInstance() throws UMOException {
        throw new UnsupportedOperationException("Direct access to underlying service object is not allowed in the SedaModel.  If this is for a unit test, make sure you are using the TestSedaModel ('seda-test')");
    }

    public QueueProfile getQueueProfile() {
        return this.queueProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public Integer getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(Integer queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    public UMOWorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(UMOWorkManager workManager) {
        this.workManager = workManager;
    }
}

