/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.resolvers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.VoidResult;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOEventContext;
import org.mule.umo.model.InvocationResult;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

public abstract class AbstractEntryPointResolver
implements UMOEntryPointResolver {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private boolean transformFirst = true;
    private boolean acceptVoidMethods = false;
    protected final ConcurrentHashMap methodCache = new ConcurrentHashMap(4);

    public boolean isTransformFirst() {
        return this.transformFirst;
    }

    public void setTransformFirst(boolean transformFirst) {
        this.transformFirst = transformFirst;
    }

    public boolean isAcceptVoidMethods() {
        return this.acceptVoidMethods;
    }

    public void setAcceptVoidMethods(boolean acceptVoidMethods) {
        this.acceptVoidMethods = acceptVoidMethods;
    }

    protected Method getMethodByName(String methodName, UMOEventContext context) {
        StringBuffer key = new StringBuffer(24).append(context.getComponent().getName()).append(".").append(methodName);
        Method method = (Method)this.methodCache.get((Object)key);
        return method;
    }

    protected Method addMethodByName(Method method, UMOEventContext context) {
        StringBuffer key = new StringBuffer(24).append(context.getComponent().getName()).append(".").append(method.getName());
        Method previousMethod = (Method)this.methodCache.putIfAbsent((Object)key, (Object)method);
        return previousMethod != null ? previousMethod : method;
    }

    protected Method addMethodByArguments(Object component, Method method, Object[] payload) {
        Method previousMethod = (Method)this.methodCache.putIfAbsent((Object)this.getCacheKeyForPayload(component, payload), (Object)method);
        return previousMethod != null ? previousMethod : method;
    }

    protected Method getMethodByArguments(Object component, Object[] payload) {
        Method method = (Method)this.methodCache.get((Object)this.getCacheKeyForPayload(component, payload));
        return method;
    }

    protected String getCacheKeyForPayload(Object component, Object[] payload) {
        StringBuffer key = new StringBuffer(48);
        for (int i = 0; i < payload.length; ++i) {
            Object o = payload[i];
            key.append(o.getClass().getName());
        }
        key.append(".").append(ClassUtils.getClassName(component.getClass()));
        return key.toString();
    }

    protected Object[] getPayloadFromMessage(UMOEventContext context) throws TransformerException {
        Object temp = this.isTransformFirst() ? context.getTransformedMessage() : context.getMessage().getPayload();
        if (temp instanceof Object[]) {
            return (Object[])temp;
        }
        if (temp instanceof NullPayload) {
            return ClassUtils.NO_ARGS;
        }
        return new Object[]{temp};
    }

    protected InvocationResult invokeMethod(Object component, Method method, Object[] arguments) throws InvocationTargetException, IllegalAccessException {
        String methodCall = null;
        if (this.logger.isDebugEnabled()) {
            methodCall = component.getClass().getName() + "." + method.getName() + "(" + StringMessageUtils.toString(ClassUtils.getClassTypes(arguments)) + ")";
            this.logger.debug((Object)("Invoking " + methodCall));
        }
        Object result = method.invoke(component, arguments);
        if (method.getReturnType().equals(Void.TYPE)) {
            result = VoidResult.getInstance();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Result of call " + methodCall + " is " + (result == null ? "null" : "not null")));
        }
        return new InvocationResult(result, method);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AbstractEntryPointResolver");
        sb.append("{transformFirst=").append(this.transformFirst);
        sb.append(", acceptVoidMethods=").append(this.acceptVoidMethods);
        sb.append('}');
        return sb.toString();
    }
}

