/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications.manager;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.Collection;
import java.util.Map;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.config.MuleConfiguration;
import org.mule.impl.internal.notifications.BlockingServerEvent;
import org.mule.impl.internal.notifications.manager.Configuration;
import org.mule.impl.internal.notifications.manager.ListenerSubscriptionPair;
import org.mule.impl.internal.notifications.manager.Policy;
import org.mule.impl.internal.notifications.manager.ServerNotificationHandler;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.util.ClassUtils;

public class ServerNotificationManager
implements Work,
Disposable,
ServerNotificationHandler {
    public static final String NULL_SUBSCRIPTION = "NULL";
    protected Log logger = LogFactory.getLog(this.getClass());
    private boolean dynamic = false;
    private Configuration configuration = new Configuration();
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private WorkListener workListener = null;
    private BlockingDeque eventQueue = new LinkedBlockingDeque();

    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    public void setNotificationDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void start(UMOWorkManager workManager) throws LifecycleException {
        try {
            workManager.scheduleWork(this, Long.MAX_VALUE, null, this.getWorkListener());
        }
        catch (WorkException e) {
            throw new LifecycleException(e, (Object)this);
        }
    }

    public void addInterfaceToType(Class iface, Class event) {
        this.configuration.addInterfaceToType(iface, event);
    }

    public void setInterfaceToTypes(Map interfaceToEvents) throws ClassNotFoundException {
        this.configuration.addAllInterfaceToTypes(interfaceToEvents);
    }

    public void addListenerSubscriptionPair(ListenerSubscriptionPair pair) {
        this.configuration.addListenerSubscriptionPair(pair);
    }

    public void addListener(UMOServerNotificationListener listener) {
        this.configuration.addListenerSubscriptionPair(new ListenerSubscriptionPair(listener));
    }

    public void addListenerSubscription(UMOServerNotificationListener listener, String subscription) {
        this.configuration.addListenerSubscriptionPair(new ListenerSubscriptionPair(listener, subscription));
    }

    public void setAllListenerSubscriptionPairs(Collection pairs) {
        this.configuration.addAllListenerSubscriptionPairs(pairs);
    }

    public void removeListener(UMOServerNotificationListener listener) {
        this.configuration.removeListener(listener);
    }

    public void removeAllListeners(Collection listeners) {
        this.configuration.removeAllListeners(listeners);
    }

    public void disableInterface(Class iface) throws ClassNotFoundException {
        this.configuration.disableInterface(iface);
    }

    public void setDisabledInterfaces(Collection interfaces) throws ClassNotFoundException {
        this.configuration.disabledAllInterfaces(interfaces);
    }

    public void disableType(Class type) throws ClassNotFoundException {
        this.configuration.disableType(type);
    }

    public void setDisabledTypes(Collection types) throws ClassNotFoundException {
        this.configuration.disableAllTypes(types);
    }

    public void fireNotification(UMOServerNotification notification) {
        block5: {
            if (!this.disposed.get()) {
                if (notification instanceof BlockingServerEvent) {
                    this.notifyListeners(notification);
                } else {
                    try {
                        this.eventQueue.put((Object)notification);
                    }
                    catch (InterruptedException e) {
                        if (this.disposed.get()) break block5;
                        this.logger.error((Object)("Failed to queue notification: " + notification), (Throwable)e);
                    }
                }
            }
        }
    }

    public boolean isNotificationEnabled(Class type) {
        return this.configuration.getPolicy().isNotificationEnabled(type);
    }

    public void dispose() {
        this.disposed.set(true);
        this.configuration = null;
        this.workListener = null;
    }

    protected void notifyListeners(UMOServerNotification notification) {
        if (!this.disposed.get()) {
            this.configuration.getPolicy().dispatch(notification);
        }
    }

    public void release() {
        this.dispose();
    }

    public void run() {
        while (!this.disposed.get()) {
            try {
                UMOServerNotification notification = (UMOServerNotification)this.eventQueue.take();
                this.notifyListeners(notification);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public WorkListener getWorkListener() {
        MuleConfiguration config;
        if (null == this.workListener && null != (config = RegistryContext.getConfiguration())) {
            this.workListener = config.getDefaultWorkListener();
        }
        return this.workListener;
    }

    public void setWorkListener(WorkListener workListener) {
        if (null == workListener) {
            throw new IllegalArgumentException("workListener may not be null");
        }
        this.workListener = workListener;
    }

    /*
     * WARNING - void declaration
     */
    public static Class toClass(Object value) throws ClassNotFoundException {
        void var1_1;
        Class clazz;
        if (value instanceof String) {
            clazz = ClassUtils.loadClass(value.toString(), value.getClass());
        } else if (value instanceof Class) {
            clazz = (Class)value;
        } else {
            throw new IllegalArgumentException("Notification types and listeners must be a Class with fully qualified class name. Value is: " + value);
        }
        return var1_1;
    }

    Policy getPolicy() {
        return this.configuration.getPolicy();
    }

    public Map getInterfaceToTypes() {
        return this.configuration.getInterfaceToTypes();
    }

    public Collection getListeners() {
        return this.configuration.getListeners();
    }
}

