/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications.manager;

import org.mule.impl.internal.notifications.manager.ServerNotificationHandler;
import org.mule.umo.manager.UMOServerNotification;

public class OptimisedNotificationHandler
implements ServerNotificationHandler {
    private ServerNotificationHandler delegate;
    private Class type;
    private boolean dynamic = false;
    private boolean enabled = false;

    public OptimisedNotificationHandler(ServerNotificationHandler delegate, Class type) {
        this.delegate = delegate;
        this.type = type;
        this.dynamic = delegate.isNotificationDynamic();
        this.enabled = delegate.isNotificationEnabled(type);
    }

    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    public boolean isNotificationEnabled(Class notfnClass) {
        if (!this.dynamic && this.type.isAssignableFrom(notfnClass)) {
            return this.enabled;
        }
        return this.delegate.isNotificationEnabled(notfnClass);
    }

    public void fireNotification(UMOServerNotification notification) {
        if (this.isNotificationEnabled(notification.getClass())) {
            this.delegate.fireNotification(notification);
        }
    }
}

