/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.util.List;
import java.util.Map;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ImmutableMuleEndpoint;
import org.mule.impl.ManagementContextAware;
import org.mule.providers.ConnectionStrategy;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOEndpointSecurityFilter;

public class MuleEndpoint
extends ImmutableMuleEndpoint
implements UMOEndpoint,
ManagementContextAware {
    private static final long serialVersionUID = 3883445445846168147L;
    public static final String ALWAYS_CREATE_STRING = "ALWAYS_CREATE";
    public static final String NEVER_CREATE_STRING = "NEVER_CREATE";

    protected MuleEndpoint() {
    }

    public void setEndpointURI(UMOEndpointURI endpointUri) throws EndpointException {
        if (this.connector != null && endpointUri != null && !this.connector.supportsProtocol(endpointUri.getFullScheme())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(this.connector.getProtocol(), endpointUri).getMessage());
        }
        if (endpointUri == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("endpointURI").getMessage());
        }
        this.endpointUri = endpointUri;
        if (endpointUri != null) {
            this.properties.putAll(endpointUri.getParams());
        }
        try {
            endpointUri.initialise();
        }
        catch (InitialisationException e) {
            throw new EndpointException(e);
        }
    }

    public void setEncoding(String endpointEncoding) {
        this.endpointEncoding = endpointEncoding;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setConnector(UMOConnector connector) {
        if (connector != null && this.endpointUri != null && !connector.supportsProtocol(this.endpointUri.getFullScheme())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(connector.getProtocol(), this.endpointUri).getMessage());
        }
        this.connector = connector;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTransformers(List transformers) {
        this.setTransformers(this.transformers, transformers);
    }

    protected void setTransformers(AtomicReference reference, List transformers) {
        TransformerUtils.discourageNullTransformers(transformers);
        reference.set((Object)transformers);
        this.updateTransformerEndpoints(reference);
    }

    public void setProperties(Map props) {
        this.properties.clear();
        this.properties.putAll(props);
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setTransactionConfig(UMOTransactionConfig config) {
        this.transactionConfig = config;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public void setDeleteUnacceptedMessages(boolean delete) {
        this.deleteUnacceptedMessages = delete;
    }

    public void setSecurityFilter(UMOEndpointSecurityFilter filter) {
        this.securityFilter = filter;
        if (this.securityFilter != null) {
            this.securityFilter.setEndpoint(this);
        }
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void setCreateConnector(int action) {
        this.createConnector = action;
    }

    public void setCreateConnectorAsString(String action) {
        this.createConnector = ALWAYS_CREATE_STRING.equals(action) ? 1 : (NEVER_CREATE_STRING.equals(action) ? 2 : 0);
    }

    public void setRemoteSync(boolean value) {
        this.remoteSync = value;
        if (value) {
            this.synchronous = true;
        }
    }

    public void setRemoteSyncTimeout(int timeout) {
        this.remoteSyncTimeout = new Integer(timeout);
    }

    public void setInitialState(String state) {
        this.initialState = state;
    }

    public void setResponseTransformers(List transformers) {
        this.setTransformers(this.responseTransformers, transformers);
        this.updateTransformerEndpoints(this.responseTransformers);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public void setManagementContext(UMOManagementContext context) {
        this.managementContext = context;
    }
}

