/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.endpoint.EndpointURIEndpointBuilder;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOEndpointFactory;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class EndpointFactory
implements UMOEndpointFactory {
    protected static final Log logger = LogFactory.getLog((Class)EndpointFactory.class);
    public static final int GET_OR_CREATE_CONNECTOR = 0;
    public static final int ALWAYS_CREATE_CONNECTOR = 1;
    public static final int NEVER_CREATE_CONNECTOR = 2;
    public static final int USE_CONNECTOR = 3;
    protected UMOManagementContext managementContext;

    public UMOImmutableEndpoint getInboundEndpoint(String uri) throws UMOException {
        logger.debug((Object)("EndpointFactory request for inbound endpoint for uri: " + uri));
        UMOEndpointBuilder endpointBuilder = this.lookupEndpointBuilder(uri);
        if (endpointBuilder == null) {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, this.managementContext);
        }
        return this.getInboundEndpoint(endpointBuilder);
    }

    public UMOImmutableEndpoint getOutboundEndpoint(String uri) throws UMOException {
        logger.debug((Object)("EndpointFactory request for outbound endpoint for uri: " + uri));
        UMOEndpointBuilder endpointBuilder = this.lookupEndpointBuilder(uri);
        if (endpointBuilder == null) {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, this.managementContext);
        }
        return this.getOutboundEndpoint(endpointBuilder);
    }

    public UMOImmutableEndpoint getResponseEndpoint(String uri) throws UMOException {
        logger.debug((Object)("EndpointFactory request for response endpoint for uri: " + uri));
        UMOEndpointBuilder endpointBuilder = this.lookupEndpointBuilder(uri);
        if (endpointBuilder == null) {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, this.managementContext);
        }
        return this.getResponseEndpoint(endpointBuilder);
    }

    public UMOImmutableEndpoint getEndpoint(UMOEndpointURI uri, String type) throws UMOException {
        logger.debug((Object)("EndpointFactory request for endpoint of type: " + type + ", for uri: " + uri));
        UMOEndpointBuilder endpointBuilder = null;
        if (uri.getEndpointName() != null) {
            endpointBuilder = this.lookupEndpointBuilder(uri.getEndpointName());
            if (endpointBuilder == null) {
                throw new IllegalArgumentException("The endpoint with name: " + uri.getEndpointName() + "was not found.");
            }
        } else {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, this.managementContext);
        }
        if ("receiver".equals(type)) {
            return this.getInboundEndpoint(endpointBuilder);
        }
        if ("sender".equals(type)) {
            return this.getOutboundEndpoint(endpointBuilder);
        }
        if ("response".equals(type)) {
            return this.getResponseEndpoint(endpointBuilder);
        }
        throw new IllegalArgumentException("The endpoint type: " + type + "is not recognized.");
    }

    protected UMOEndpointBuilder lookupEndpointBuilder(String endpointName) {
        logger.debug((Object)("Looking up EndpointBuilder with name:" + endpointName + " in registry"));
        UMOEndpointBuilder endpointBuilder = RegistryContext.getRegistry().lookupEndpointBuilder(endpointName);
        if (endpointBuilder != null) {
            logger.debug((Object)("EndpointBuilder with name:" + endpointName + " FOUND"));
        }
        return endpointBuilder;
    }

    public UMOImmutableEndpoint getInboundEndpoint(UMOEndpointBuilder builder) throws UMOException {
        return builder.buildInboundEndpoint();
    }

    public UMOImmutableEndpoint getOutboundEndpoint(UMOEndpointBuilder builder) throws UMOException {
        return builder.buildOutboundEndpoint();
    }

    public UMOImmutableEndpoint getResponseEndpoint(UMOEndpointBuilder builder) throws UMOException {
        return builder.buildResponseEndpoint();
    }

    public UMOEndpointBuilder getEndpointBuilder(String uri) throws UMOException {
        logger.debug((Object)("EndpointFactory request for endpoint builder for uri: " + uri));
        UMOEndpointBuilder endpointBuilder = this.lookupEndpointBuilder(uri);
        if (endpointBuilder != null) {
            try {
                endpointBuilder = (UMOEndpointBuilder)endpointBuilder.clone();
            }
            catch (Exception e) {
                throw new EndpointException(CoreMessages.failedToClone("global endpoint EndpointBuilder"), (Throwable)e);
            }
        } else {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint builder for uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, this.managementContext);
        }
        return endpointBuilder;
    }

    public void setManagementContext(UMOManagementContext context) {
        this.managementContext = context;
    }
}

