/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.container;

import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.mule.impl.container.AbstractContainerContext;
import org.mule.registry.RegistrationException;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.util.TemplateParser;

public class PropertiesContainerContext
extends AbstractContainerContext
implements TemplateParser.TemplateCallback {
    protected Map systemProperties;
    protected Map properties;
    protected boolean includeSystemProperties = true;
    protected boolean enableTemplates = false;
    protected TemplateParser templateParser = TemplateParser.createAntStyleParser();

    public PropertiesContainerContext() {
        super("properties");
    }

    public void initialise() throws InitialisationException {
        if (this.properties != null) {
            Iterator iterator = this.properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String value = entry.getValue().toString();
                value = this.templateParser.parse((TemplateParser.TemplateCallback)this, value);
                try {
                    this.managementContext.getRegistry().registerObject(entry.getKey().toString(), value, this.managementContext);
                }
                catch (RegistrationException e) {
                    throw new InitialisationException((Throwable)e, (Initialisable)this);
                }
            }
        }
        this.setSystemProperties(null);
    }

    public Object match(String token) {
        return this.managementContext.getRegistry().lookupObject(token);
    }

    public void configure(Reader configuration) throws ContainerException {
        throw new UnsupportedOperationException("configure");
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        if (key == null) {
            throw new ObjectNotFoundException("null");
        }
        Object value = this.managementContext.getRegistry().lookupObject(key.toString());
        if (value == null) {
            throw new ObjectNotFoundException(key.toString());
        }
        if (value instanceof String && this.enableTemplates) {
            value = this.templateParser.parse(this.properties, value.toString());
        }
        return value;
    }

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map properties) {
        String value;
        Map.Entry entry;
        this.systemProperties = properties;
        if (this.systemProperties != null) {
            Iterator iterator = this.systemProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                value = entry.getValue().toString();
                value = this.templateParser.parse(this.systemProperties, value);
                value = this.templateParser.parse((TemplateParser.TemplateCallback)this, value);
                System.setProperty(entry.getKey().toString(), value);
            }
        }
        if (this.includeSystemProperties) {
            Properties props = System.getProperties();
            Iterator iterator = props.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                value = entry.getValue().toString();
                value = this.templateParser.parse((TemplateParser.TemplateCallback)this, value.toString());
                try {
                    this.managementContext.getRegistry().registerObject(entry.getKey().toString(), value, this.managementContext);
                }
                catch (RegistrationException e) {
                    this.logger.error((Object)e);
                }
            }
        }
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public boolean isIncludeSystemProperties() {
        return this.includeSystemProperties;
    }

    public void setIncludeSystemProperties(boolean includeSystemProperties) {
        this.includeSystemProperties = includeSystemProperties;
    }

    public boolean isEnableTemplates() {
        return this.enableTemplates;
    }

    public void setEnableTemplates(boolean enableTemplates) {
        this.enableTemplates = enableTemplates;
    }
}

