/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleSession;
import org.mule.impl.ResponseOutputStream;
import org.mule.impl.ThreadSafeAccess;
import org.mule.impl.security.MuleCredentials;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.PropertyScope;
import org.mule.umo.security.UMOCredentials;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.MapUtils;
import org.mule.util.UUID;

public class MuleEvent
extends EventObject
implements UMOEvent,
ThreadSafeAccess {
    private static final long serialVersionUID = 1L;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private transient UMOImmutableEndpoint endpoint = null;
    private String id = null;
    private UMOMessage message = null;
    private transient UMOSession session;
    private boolean stopFurtherProcessing = false;
    private boolean synchronous = false;
    private int timeout = Integer.MIN_VALUE;
    private transient ResponseOutputStream outputStream = null;
    private transient Object transformedMessage = null;
    private UMOCredentials credentials = null;
    protected String[] ignoredPropertyOverrides = new String[]{"method"};

    public MuleEvent(UMOMessage message, UMOImmutableEndpoint endpoint, UMOComponent component, UMOEvent previousEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = this.generateEventId();
        this.session = previousEvent.getSession();
        ((MuleSession)this.session).setComponent(component);
        this.endpoint = endpoint;
        this.synchronous = previousEvent.isSynchronous();
        this.timeout = previousEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)previousEvent.getOutputStream();
        this.fillProperties(previousEvent);
    }

    public MuleEvent(UMOMessage message, UMOImmutableEndpoint endpoint, UMOSession session, boolean synchronous) {
        this(message, endpoint, session, synchronous, null);
    }

    public MuleEvent(UMOMessage message, UMOImmutableEndpoint endpoint, UMOSession session, boolean synchronous, ResponseOutputStream outputStream) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = this.generateEventId();
        this.synchronous = synchronous;
        this.outputStream = outputStream;
        this.fillProperties(null);
    }

    public MuleEvent(UMOMessage message, UMOImmutableEndpoint endpoint, UMOSession session, String eventId, boolean synchronous) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = eventId;
        this.synchronous = synchronous;
        this.fillProperties(null);
    }

    public MuleEvent(UMOMessage message, UMOEvent rewriteEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = rewriteEvent.getId();
        this.session = rewriteEvent.getSession();
        ((MuleSession)this.session).setComponent(rewriteEvent.getComponent());
        this.endpoint = rewriteEvent.getEndpoint();
        this.synchronous = rewriteEvent.isSynchronous();
        this.timeout = rewriteEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)rewriteEvent.getOutputStream();
        if (rewriteEvent instanceof MuleEvent) {
            this.transformedMessage = ((MuleEvent)rewriteEvent).getCachedMessage();
        }
        this.fillProperties(rewriteEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillProperties(UMOEvent previousEvent) {
        if (previousEvent != null) {
            UMOMessage msg;
            UMOMessage uMOMessage = msg = previousEvent.getMessage();
            synchronized (uMOMessage) {
                Iterator iterator = msg.getPropertyNames().iterator();
                while (iterator.hasNext()) {
                    String prop = (String)iterator.next();
                    Object value = msg.getProperty(prop);
                    if (this.ignoreProperty(prop)) continue;
                    this.message.setProperty(prop, value);
                }
            }
        }
        if (this.endpoint != null && this.endpoint.getProperties() != null) {
            Iterator iterator = this.endpoint.getProperties().keySet().iterator();
            while (iterator.hasNext()) {
                String prop = (String)iterator.next();
                Object value = this.endpoint.getProperties().get(prop);
                if (this.ignoreProperty(prop)) continue;
                this.message.setProperty(prop, value, PropertyScope.INVOCATION);
            }
        }
        this.setCredentials();
    }

    protected boolean ignoreProperty(String key) {
        if (key == null) {
            return true;
        }
        for (int i = 0; i < this.ignoredPropertyOverrides.length; ++i) {
            if (!key.equals(this.ignoredPropertyOverrides[i])) continue;
            return false;
        }
        return null != this.message.getProperty(key);
    }

    protected void setCredentials() {
        if (null != this.endpoint && null != this.endpoint.getEndpointURI() && null != this.endpoint.getEndpointURI().getUserInfo()) {
            String userName = this.endpoint.getEndpointURI().getUser();
            String password = this.endpoint.getEndpointURI().getPassword();
            if (password != null && userName != null) {
                this.credentials = new MuleCredentials(userName, password.toCharArray());
            }
        }
    }

    public UMOCredentials getCredentials() {
        return this.credentials;
    }

    Object getCachedMessage() {
        return this.transformedMessage;
    }

    public UMOMessage getMessage() {
        return this.message;
    }

    public byte[] getMessageAsBytes() throws MuleException {
        try {
            return this.message.getPayloadAsBytes();
        }
        catch (Exception e) {
            throw new MuleException(CoreMessages.cannotReadPayloadAsBytes(this.message.getPayload().getClass().getName()), (Throwable)e);
        }
    }

    public Object getTransformedMessage() throws TransformerException {
        return this.getTransformedMessage(null);
    }

    public Object getTransformedMessage(Class outputType) throws TransformerException {
        this.message.applyTransformers(this.endpoint.getTransformers());
        if (outputType == null) {
            return this.message.getPayload();
        }
        return this.message.getPayload(outputType);
    }

    public byte[] getTransformedMessageAsBytes() throws TransformerException {
        Object obj = this.getTransformedMessage([B.class);
        return (byte[])obj;
    }

    public String getTransformedMessageAsString() throws TransformerException {
        return this.getTransformedMessageAsString(this.getEncoding());
    }

    public String getMessageAsString() throws UMOException {
        return this.getMessageAsString(this.getEncoding());
    }

    public String getTransformedMessageAsString(String encoding) throws TransformerException {
        try {
            return new String(this.getTransformedMessageAsBytes(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformerException(this.endpoint.getTransformers(), (Throwable)e);
        }
    }

    public String getMessageAsString(String encoding) throws UMOException {
        try {
            return this.message.getPayloadAsString(encoding);
        }
        catch (Exception e) {
            throw new MuleException(CoreMessages.cannotReadPayloadAsString(this.message.getClass().getName()), (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public Object getProperty(String name, boolean exhaustiveSearch) {
        return this.getProperty(name, null, exhaustiveSearch);
    }

    public Object getProperty(String name, Object defaultValue, boolean exhaustiveSearch) {
        Object property = this.message.getProperty(name);
        if (exhaustiveSearch) {
            if (property == null) {
                property = MapUtils.getObject((Map)this.getEndpoint().getEndpointURI().getParams(), (Object)name, null);
            }
            if (property == null) {
                try {
                    property = PropertyUtils.getProperty((Object)this.getEndpoint().getConnector(), (String)name);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return property == null ? defaultValue : property;
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("Event: ").append(this.getId());
        buf.append(", sync=").append(this.isSynchronous());
        buf.append(", stop processing=").append(this.isStopFurtherProcessing());
        buf.append(", ").append(this.endpoint);
        return buf.toString();
    }

    protected String generateEventId() {
        return UUID.getUUID();
    }

    public UMOSession getSession() {
        return this.session;
    }

    void setSession(UMOSession session) {
        this.session = session;
    }

    public UMOComponent getComponent() {
        return this.session.getComponent();
    }

    public boolean isStopFurtherProcessing() {
        return this.stopFurtherProcessing;
    }

    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.stopFurtherProcessing = stopFurtherProcessing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleEvent)) {
            return false;
        }
        MuleEvent event = (MuleEvent)o;
        if (this.message != null ? !this.message.equals(event.message) : event.message != null) {
            return false;
        }
        return this.id.equals(event.id);
    }

    public int hashCode() {
        return 29 * this.id.hashCode() + (this.message != null ? this.message.hashCode() : 0);
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean value) {
        this.synchronous = value;
    }

    public int getTimeout() {
        if (this.timeout == Integer.MIN_VALUE) {
            this.timeout = this.endpoint.getRemoteSyncTimeout();
        }
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void marshallTransformers(List transformers, ObjectOutputStream out) throws IOException {
        if (transformers != null) {
            Iterator transformer = transformers.iterator();
            while (transformer.hasNext()) {
                out.writeObject(((UMOTransformer)transformer.next()).getName());
            }
        }
    }

    private List unmarshallTransformers(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LinkedList<UMOTransformer> transformers = new LinkedList<UMOTransformer>();
        try {
            while (true) {
                String transformerName = (String)in.readObject();
                transformers.add(RegistryContext.getRegistry().lookupTransformer(transformerName));
            }
        }
        catch (OptionalDataException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to load transformers from stream", (Throwable)e);
            }
            return transformers;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.endpoint.getEndpointURI().toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.logger = LogFactory.getLog(this.getClass());
        in.defaultReadObject();
        String uri = (String)in.readObject();
        try {
            this.endpoint = this.getManagementContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(uri);
        }
        catch (UMOException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public String getEncoding() {
        String encoding = this.message.getEncoding();
        if (encoding == null) {
            encoding = this.endpoint.getEncoding();
        }
        return encoding;
    }

    public UMOManagementContext getManagementContext() {
        return this.endpoint.getManagementContext();
    }

    public ThreadSafeAccess newThreadCopy() {
        if (this.message instanceof ThreadSafeAccess) {
            MuleEvent copy = new MuleEvent((UMOMessage)((Object)((ThreadSafeAccess)((Object)this.message)).newThreadCopy()), this);
            copy.resetAccessControl();
            return copy;
        }
        return this;
    }

    public void resetAccessControl() {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).resetAccessControl();
        }
    }

    public void assertAccess(boolean write) {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).assertAccess(write);
        }
    }
}

