/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.processors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.PropertyConfiguration;
import org.mule.util.CoreXMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class RequireAttribute
implements PreProcessor {
    private Set required;

    public RequireAttribute(String required) {
        this(new String[]{required});
    }

    public RequireAttribute(String[] required) {
        this.required = new HashSet<String>(Arrays.asList(required));
    }

    public void preProcess(PropertyConfiguration config, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        Iterator names = this.required.iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            boolean found = false;
            for (int i = 0; i < attributes.getLength() && !found; ++i) {
                String alias = CoreXMLUtils.attributeName((Attr)attributes.item(i));
                found = name.equals(alias);
            }
            if (found) continue;
            throw new RequireAttributeException("Attribute " + name + " is required here.");
        }
    }

    public static class RequireAttributeException
    extends IllegalStateException {
        private RequireAttributeException(String message) {
            super(message);
        }
    }
}

